<?php

/*
* The MIT License
*
* Copyright (c) 2025 "YooMoney", NBСO LLC
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

namespace YooKassa\Model\Refund;

use YooKassa\Common\AbstractObject;
use YooKassa\Validator\Constraints as Assert;

/**
 * Класс, представляющий модель RefundAuthorizationDetails.
 *
 * Данные об авторизации возврата.
 * Присутствуют только для возвратов платежей, совершенных этими способами оплаты: банковская карта, Mir Pay.
 *
 * @category Class
 * @package  YooKassa\Model
 * @author   cms@yoomoney.ru
 * @link     https://yookassa.ru/developers/api
 * @property string $rrn Retrieval Reference Number — идентификатор банковской транзакции.
 */
class RefundAuthorizationDetails extends AbstractObject
{
    /**
     * Retrieval Reference Number — идентификатор банковской транзакции.
     *
     * @var string|null
     */
    #[Assert\Type('string')]
    private ?string $_rrn = null;

    /**
     * Возвращает rrn.
     *
     * @return string|null
     */
    public function getRrn(): ?string
    {
        return $this->_rrn;
    }

    /**
     * Устанавливает rrn.
     *
     * @param string|null $rrn Retrieval Reference Number — идентификатор банковской транзакции.
     *
     * @return self
     */
    public function setRrn(?string $rrn = null): self
    {
        $this->_rrn = $this->validatePropertyValue('_rrn', $rrn);
        return $this;
    }
}

