<?php

declare(strict_types=1);

namespace Gemini\Enums;

/**
 * Defines the reason why the model stopped generating tokens.
 *
 * https://ai.google.dev/api/generate-content#FinishReason
 */
enum FinishReason: string
{
    /**
     * Default value. This value is unused.
     */
    case FINISH_REASON_UNSPECIFIED = 'FINISH_REASON_UNSPECIFIED';

    /**
     * Natural stop point of the model or provided stop sequence.
     */
    case STOP = 'STOP';

    /**
     * The maximum number of tokens as specified in the request was reached.
     */
    case MAX_TOKENS = 'MAX_TOKENS';

    /**
     * The candidate content was flagged for safety reasons.
     */
    case SAFETY = 'SAFETY';

    /**
     * The candidate content was flagged for recitation reasons.
     */
    case RECITATION = 'RECITATION';

    /**
     * The response candidate content was flagged for using an unsupported language.
     */
    case LANGUAGE = 'LANGUAGE';

    /**
     * Unknown reason.
     */
    case OTHER = 'OTHER';

    /**
     * Token generation stopped because the content contains forbidden terms.
     */
    case BLOCKLIST = 'BLOCKLIST';

    /**
     * Token generation stopped for potentially containing prohibited content.
     */
    case PROHIBITED_CONTENT = 'PROHIBITED_CONTENT';

    /**
     * Token generation stopped because the content potentially contains Sensitive Personally Identifiable Information (SPII).
     */
    case SPII = 'SPII';

    /**
     * The function call generated by the model is invalid.
     */
    case MALFORMED_FUNCTION_CALL = 'MALFORMED_FUNCTION_CALL';

    /**
     * Token generation stopped because generated images contain safety violations.
     */
    case IMAGE_SAFETY = 'IMAGE_SAFETY';
}
