<style>
    .disabled-link a {
        color: #ccc;
        pointer-events: none;
        cursor: default;
    }
</style>

<div class="col-xl-3 col-lg-4">
    <div class="profile-settings-menu sticky_top_lg">
        <div class="profile-bars d-lg-none">
            <i class="fa-solid fa-bars"></i>
        </div>
        <div class="profile-settings-menu-inner">
            <div class="profile-close d-lg-none">
                <i class="fa-solid fa-times"></i>
            </div>
            @if (Auth::guard('web')->check())
                @if (Auth::guard('web')->user()->user_type == 2)
                    @if(Session::get('user_role') == 'client')
                        @include('frontend.user.layout.partials.act-as-client-sidebar')
                    @else
                    <ul class="profile-settings-menu-list">
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.dashboard')) active @endif">
                            <a href="{{ route('freelancer.dashboard') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M7 10.75H5C2.58 10.75 1.25 9.42 1.25 7V5C1.25 2.58 2.58 1.25 5 1.25H7C9.42 1.25 10.75 2.58 10.75 5V7C10.75 9.42 9.42 10.75 7 10.75ZM5 2.75C3.42 2.75 2.75 3.42 2.75 5V7C2.75 8.58 3.42 9.25 5 9.25H7C8.58 9.25 9.25 8.58 9.25 7V5C9.25 3.42 8.58 2.75 7 2.75H5Z" fill="#667085"/>
                                    <path d="M19 10.75H17C14.58 10.75 13.25 9.42 13.25 7V5C13.25 2.58 14.58 1.25 17 1.25H19C21.42 1.25 22.75 2.58 22.75 5V7C22.75 9.42 21.42 10.75 19 10.75ZM17 2.75C15.42 2.75 14.75 3.42 14.75 5V7C14.75 8.58 15.42 9.25 17 9.25H19C20.58 9.25 21.25 8.58 21.25 7V5C21.25 3.42 20.58 2.75 19 2.75H17Z" fill="#667085"/>
                                    <path d="M19 22.75H17C14.58 22.75 13.25 21.42 13.25 19V17C13.25 14.58 14.58 13.25 17 13.25H19C21.42 13.25 22.75 14.58 22.75 17V19C22.75 21.42 21.42 22.75 19 22.75ZM17 14.75C15.42 14.75 14.75 15.42 14.75 17V19C14.75 20.58 15.42 21.25 17 21.25H19C20.58 21.25 21.25 20.58 21.25 19V17C21.25 15.42 20.58 14.75 19 14.75H17Z" fill="#667085"/>
                                    <path d="M7 22.75H5C2.58 22.75 1.25 21.42 1.25 19V17C1.25 14.58 2.58 13.25 5 13.25H7C9.42 13.25 10.75 14.58 10.75 17V19C10.75 21.42 9.42 22.75 7 22.75ZM5 14.75C3.42 14.75 2.75 15.42 2.75 17V19C2.75 20.58 3.42 21.25 5 21.25H7C8.58 21.25 9.25 20.58 9.25 19V17C9.25 15.42 8.58 14.75 7 14.75H5Z" fill="#667085"/>
                                </svg>
                                {{ __('Dashboard') }}
                            </a>
                        </li>
                        @if(moduleExists('PromoteFreelancer'))
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.promoted.list')) active @endif">
                            <a href="{{ route('freelancer.promoted.list') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_7034_8828)">
                                        <path d="M17.7192 10.4629C18.2961 10.0764 18.7097 9.49966 18.8921 8.81909C19.0914 8.07518 18.9903 7.30024 18.6074 6.63701C18.2245 5.97377 17.6039 5.49874 16.86 5.29938C16.1795 5.11704 15.4732 5.18688 14.85 5.49316L13.2442 2.71193C12.9024 2.11985 12.2885 1.77476 11.6068 1.78638C10.9233 1.7989 10.3243 2.16701 10.0042 2.77108C9.77952 3.19549 9.56844 3.63635 9.34498 4.10313C8.43425 6.00555 7.40202 8.1618 5.17044 9.45021L2.30295 11.1057C1.31591 11.6756 0.608891 12.5994 0.312078 13.707C0.0153127 14.8146 0.165688 15.9682 0.735547 16.9552C1.52778 18.3274 2.97013 19.0954 4.45123 19.0954C4.99142 19.0954 5.53672 18.9931 6.05759 18.7808L8.0622 22.2529C8.47695 22.9713 9.23183 23.3732 10.0071 23.3732C10.3871 23.3732 10.772 23.2766 11.1241 23.0734C11.641 22.7749 12.0112 22.2914 12.1665 21.7118C12.3218 21.1323 12.243 20.5284 11.9445 20.0115L9.97203 16.595C12.0487 15.6077 14.2286 15.7752 16.1693 15.9252C16.6858 15.9652 17.1735 16.0029 17.6538 16.0204C18.336 16.0449 18.9553 15.7107 19.3078 15.1249C19.6603 14.5392 19.6668 13.8362 19.325 13.2441L17.7192 10.4628L17.7192 10.4629ZM16.5567 6.43132C16.9983 6.54963 17.3661 6.83074 17.5925 7.22294C18.0297 7.98002 17.8178 8.93627 17.1313 9.44449L15.438 6.51166C15.7885 6.35946 16.179 6.33007 16.5567 6.43132H16.5567ZM4.44931 17.9239C3.37363 17.9238 2.32588 17.366 1.75048 16.3693C1.33714 15.6534 1.2283 14.8156 1.44411 14.0104C1.65988 13.2051 2.17302 12.534 2.88894 12.1206L5.24923 10.7579L8.36239 16.1434L5.99923 17.5078C5.51061 17.7899 4.9767 17.9239 4.44931 17.9239ZM11.0346 21.4086C10.9604 21.6858 10.784 21.9166 10.5382 22.0586C10.0275 22.3534 9.37203 22.1779 9.07709 21.6671L7.09255 18.2297L8.94514 17.1601L10.9297 20.5975C11.0716 20.8433 11.1089 21.1314 11.0346 21.4086H11.0346ZM18.3038 14.5207C18.1706 14.7421 17.9557 14.8594 17.6967 14.8494C17.2401 14.8327 16.7639 14.7959 16.2597 14.7569C14.1418 14.5933 11.7605 14.4098 9.38736 15.5749L6.25405 10.1546C8.4523 8.68043 9.48448 6.52577 10.402 4.60919C10.6202 4.15343 10.8263 3.72293 11.0398 3.31962C11.1608 3.09119 11.3698 2.9628 11.6282 2.95812C11.6331 2.95802 11.638 2.95798 11.6428 2.95798C11.8947 2.95798 12.1026 3.0783 12.2294 3.29791L18.3102 13.8302C18.4394 14.054 18.4372 14.2993 18.3039 14.5207L18.3038 14.5207ZM16.7817 3.01591L17.9918 0.920038C18.1536 0.639772 18.5119 0.543725 18.7922 0.705584C19.0724 0.867397 19.1684 1.22576 19.0066 1.50598L17.7966 3.60185C17.6881 3.78982 17.4911 3.89491 17.2886 3.89491C17.1892 3.89491 17.0885 3.8696 16.9962 3.8163C16.7159 3.65449 16.6199 3.29613 16.7817 3.01591ZM22.2217 5.22682L20.0751 6.46619C19.9829 6.51944 19.8821 6.5448 19.7827 6.5448C19.5802 6.5448 19.3833 6.43971 19.2748 6.25174C19.1129 5.97148 19.209 5.61312 19.4892 5.45135L21.6358 4.21198C21.916 4.05012 22.2744 4.14621 22.4362 4.42643C22.598 4.70665 22.502 5.06505 22.2217 5.22682ZM23.8366 9.44266C23.8366 9.76624 23.5742 10.0286 23.2506 10.0286H20.8305C20.5069 10.0286 20.2445 9.76629 20.2445 9.44266C20.2445 9.11904 20.5069 8.85673 20.8305 8.85673H23.2506C23.5742 8.85673 23.8366 9.11904 23.8366 9.44266Z" fill="#667085"/>
                                    </g>
                                </svg>
                                {{ __('Promoted List') }}
                            </a>
                        </li>
                        @endif
                        @if(get_static_option('project_enable_disable') != 'disable')
                            @if(moduleExists('SecurityManage'))
                                @if(Auth::guard('web')->user()->freeze_project == 'freeze')
                                    <li class="profile-settings-menu-item @if(Auth::guard('web')->user()->freeze_project == 'freeze') disabled-link @endif">
                                        <a href="#" class="profile-settings-menu-item-link">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                        d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M6.192 7.81001C5.952 7.81001 5.732 7.70001 5.582 7.50001C5.412 7.27001 5.392 6.97001 5.522 6.72001C5.692 6.38001 5.932 6.05001 6.242 5.75001L9.492 2.49C11.152 0.840002 13.852 0.840002 15.512 2.49L17.262 4.26002C18.002 4.99002 18.452 5.97002 18.502 7.01002C18.512 7.24002 18.422 7.46 18.252 7.61C18.082 7.76 17.852 7.83002 17.632 7.79002C17.432 7.76002 17.222 7.75001 17.002 7.75001H7.002C6.762 7.75001 6.532 7.77 6.302 7.8C6.272 7.81 6.232 7.81001 6.192 7.81001ZM7.862 6.25001H16.822C16.692 5.91001 16.482 5.60002 16.202 5.32002L14.442 3.54002C13.372 2.48002 11.622 2.48002 10.542 3.54002L7.862 6.25001Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                                        fill="#667085" />
                                            </svg>
                                            {{ __('Create a Project') }}
                                        </a>
                                    </li>
                                @else
                                    <li class="profile-settings-menu-item">
                                        <a href="{{ route('freelancer.project.create') }}" class="profile-settings-menu-item-link">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                        d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M6.192 7.81001C5.952 7.81001 5.732 7.70001 5.582 7.50001C5.412 7.27001 5.392 6.97001 5.522 6.72001C5.692 6.38001 5.932 6.05001 6.242 5.75001L9.492 2.49C11.152 0.840002 13.852 0.840002 15.512 2.49L17.262 4.26002C18.002 4.99002 18.452 5.97002 18.502 7.01002C18.512 7.24002 18.422 7.46 18.252 7.61C18.082 7.76 17.852 7.83002 17.632 7.79002C17.432 7.76002 17.222 7.75001 17.002 7.75001H7.002C6.762 7.75001 6.532 7.77 6.302 7.8C6.272 7.81 6.232 7.81001 6.192 7.81001ZM7.862 6.25001H16.822C16.692 5.91001 16.482 5.60002 16.202 5.32002L14.442 3.54002C13.372 2.48002 11.622 2.48002 10.542 3.54002L7.862 6.25001Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                                        fill="#667085" />
                                            </svg>
                                            {{ __('Create a Project') }}
                                        </a>
                                    </li>
                                @endif
                            @else
                                <li class="profile-settings-menu-item">
                                    <a href="{{ route('freelancer.project.create') }}" class="profile-settings-menu-item-link">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                    d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M6.192 7.81001C5.952 7.81001 5.732 7.70001 5.582 7.50001C5.412 7.27001 5.392 6.97001 5.522 6.72001C5.692 6.38001 5.932 6.05001 6.242 5.75001L9.492 2.49C11.152 0.840002 13.852 0.840002 15.512 2.49L17.262 4.26002C18.002 4.99002 18.452 5.97002 18.502 7.01002C18.512 7.24002 18.422 7.46 18.252 7.61C18.082 7.76 17.852 7.83002 17.632 7.79002C17.432 7.76002 17.222 7.75001 17.002 7.75001H7.002C6.762 7.75001 6.532 7.77 6.302 7.8C6.272 7.81 6.232 7.81001 6.192 7.81001ZM7.862 6.25001H16.822C16.692 5.91001 16.482 5.60002 16.202 5.32002L14.442 3.54002C13.372 2.48002 11.622 2.48002 10.542 3.54002L7.862 6.25001Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                                    fill="#667085" />
                                        </svg>
                                        {{ __('Create a Project') }}
                                    </a>
                                </li>
                            @endif
                        @endif
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.order.all') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15 12.95H8C7.59 12.95 7.25 12.61 7.25 12.2C7.25 11.79 7.59 11.45 8 11.45H15C15.41 11.45 15.75 11.79 15.75 12.2C15.75 12.61 15.41 12.95 15 12.95Z"
                                        fill="#667085" />
                                    <path
                                        d="M12.38 16.95H8C7.59 16.95 7.25 16.61 7.25 16.2C7.25 15.79 7.59 15.45 8 15.45H12.38C12.79 15.45 13.13 15.79 13.13 16.2C13.13 16.61 12.79 16.95 12.38 16.95Z"
                                        fill="#667085" />
                                    <path
                                        d="M14 6.75H10C9.04 6.75 7.25 6.75 7.25 4C7.25 1.25 9.04 1.25 10 1.25H14C14.96 1.25 16.75 1.25 16.75 4C16.75 4.96 16.75 6.75 14 6.75ZM10 2.75C9.01 2.75 8.75 2.75 8.75 4C8.75 5.25 9.01 5.25 10 5.25H14C15.25 5.25 15.25 4.99 15.25 4C15.25 2.75 14.99 2.75 14 2.75H10Z"
                                        fill="#667085" />
                                    <path
                                        d="M15 22.7501H9C3.38 22.7501 2.25 20.1701 2.25 16.0001V10.0001C2.25 5.44005 3.9 3.49005 7.96 3.28005C8.36 3.26005 8.73 3.57005 8.75 3.99005C8.77 4.41005 8.45 4.75005 8.04 4.77005C5.2 4.93005 3.75 5.78005 3.75 10.0001V16.0001C3.75 19.7001 4.48 21.2501 9 21.2501H15C19.52 21.2501 20.25 19.7001 20.25 16.0001V10.0001C20.25 5.78005 18.8 4.93005 15.96 4.77005C15.55 4.75005 15.23 4.39005 15.25 3.98005C15.27 3.57005 15.63 3.25005 16.04 3.27005C20.1 3.49005 21.75 5.44005 21.75 9.99005V15.9901C21.75 20.1701 20.62 22.7501 15 22.7501Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('My Orders') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.offers') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12 22.75C11.37 22.75 10.78 22.51 10.34 22.06L8.82001 20.54C8.70001 20.42 8.38 20.29 8.22 20.29H6.06C4.76 20.29 3.70999 19.2399 3.70999 17.9399V15.78C3.70999 15.62 3.57999 15.3 3.45999 15.18L1.94 13.66C1.5 13.22 1.25 12.63 1.25 12C1.25 11.37 1.49 10.7799 1.94 10.3399L3.45999 8.81991C3.57999 8.69991 3.70999 8.37994 3.70999 8.21994V6.06002C3.70999 4.76002 4.76 3.70993 6.06 3.70993H8.22C8.38 3.70993 8.70001 3.57993 8.82001 3.45993L10.34 1.93991C11.22 1.05991 12.78 1.05991 13.66 1.93991L15.18 3.45993C15.3 3.57993 15.62 3.70993 15.78 3.70993H17.94C19.24 3.70993 20.29 4.76002 20.29 6.06002V8.21994C20.29 8.37994 20.42 8.69991 20.54 8.81991L22.06 10.3399C22.5 10.7799 22.75 11.37 22.75 12C22.75 12.63 22.51 13.22 22.06 13.66L20.54 15.18C20.42 15.3 20.29 15.62 20.29 15.78V17.9399C20.29 19.2399 19.24 20.29 17.94 20.29H15.78C15.62 20.29 15.3 20.42 15.18 20.54L13.66 22.06C13.22 22.51 12.63 22.75 12 22.75ZM4.51999 14.12C4.91999 14.52 5.20999 15.22 5.20999 15.78V17.9399C5.20999 18.4099 5.59 18.79 6.06 18.79H8.22C8.78 18.79 9.48 19.0799 9.88 19.4799L11.4 21C11.72 21.32 12.28 21.32 12.6 21L14.12 19.4799C14.52 19.0799 15.22 18.79 15.78 18.79H17.94C18.41 18.79 18.79 18.4099 18.79 17.9399V15.78C18.79 15.22 19.08 14.52 19.48 14.12L21 12.5999C21.16 12.4399 21.25 12.23 21.25 12C21.25 11.77 21.16 11.56 21 11.4L19.48 9.87997C19.08 9.47997 18.79 8.77994 18.79 8.21994V6.06002C18.79 5.59002 18.41 5.20993 17.94 5.20993H15.78C15.22 5.20993 14.52 4.91999 14.12 4.51999L12.6 2.99997C12.28 2.67997 11.72 2.67997 11.4 2.99997L9.88 4.51999C9.48 4.91999 8.78 5.20993 8.22 5.20993H6.06C5.59 5.20993 5.20999 5.59002 5.20999 6.06002V8.21994C5.20999 8.77994 4.91999 9.47997 4.51999 9.87997L3 11.4C2.84 11.56 2.75 11.77 2.75 12C2.75 12.23 2.84 12.4399 3 12.5999L4.51999 14.12Z"
                                        fill="#667085" />
                                    <path
                                        d="M15.0022 16C14.4422 16 13.9922 15.55 13.9922 15C13.9922 14.45 14.4422 14 14.9922 14C15.5422 14 15.9922 14.45 15.9922 15C15.9922 15.55 15.5522 16 15.0022 16Z"
                                        fill="#667085" />
                                    <path
                                        d="M9.01001 10C8.45001 10 8 9.55 8 9C8 8.45 8.45 8 9 8C9.55 8 10 8.45 10 9C10 9.55 9.56001 10 9.01001 10Z"
                                        fill="#667085" />
                                    <path
                                        d="M8.9975 15.75C8.8075 15.75 8.6175 15.68 8.4675 15.53C8.1775 15.24 8.1775 14.7599 8.4675 14.4699L14.4675 8.46994C14.7575 8.17994 15.2375 8.17994 15.5275 8.46994C15.8175 8.75994 15.8175 9.24 15.5275 9.53L9.5275 15.53C9.3775 15.68 9.1875 15.75 8.9975 15.75Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('My Offers') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.proposal') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M17.6201 9.62012H12.3701C11.9601 9.62012 11.6201 9.28012 11.6201 8.87012C11.6201 8.46012 11.9601 8.12012 12.3701 8.12012H17.6201C18.0301 8.12012 18.3701 8.46012 18.3701 8.87012C18.3701 9.28012 18.0401 9.62012 17.6201 9.62012Z" fill="#667085"/>
                                    <path d="M7.12006 10.3803C6.93006 10.3803 6.74006 10.3103 6.59006 10.1603L5.84006 9.41031C5.55006 9.12031 5.55006 8.64031 5.84006 8.35031C6.13006 8.06031 6.61006 8.06031 6.90006 8.35031L7.12006 8.57031L8.84006 6.85031C9.13006 6.56031 9.61006 6.56031 9.90006 6.85031C10.1901 7.14031 10.1901 7.62031 9.90006 7.91031L7.65006 10.1603C7.51006 10.3003 7.32006 10.3803 7.12006 10.3803Z" fill="#667085"/>
                                    <path d="M17.6201 16.6201H12.3701C11.9601 16.6201 11.6201 16.2801 11.6201 15.8701C11.6201 15.4601 11.9601 15.1201 12.3701 15.1201H17.6201C18.0301 15.1201 18.3701 15.4601 18.3701 15.8701C18.3701 16.2801 18.0401 16.6201 17.6201 16.6201Z" fill="#667085"/>
                                    <path d="M7.12006 17.3803C6.93006 17.3803 6.74006 17.3103 6.59006 17.1603L5.84006 16.4103C5.55006 16.1203 5.55006 15.6403 5.84006 15.3503C6.13006 15.0603 6.61006 15.0603 6.90006 15.3503L7.12006 15.5703L8.84006 13.8503C9.13006 13.5603 9.61006 13.5603 9.90006 13.8503C10.1901 14.1403 10.1901 14.6203 9.90006 14.9103L7.65006 17.1603C7.51006 17.3003 7.32006 17.3803 7.12006 17.3803Z" fill="#667085"/>
                                    <path d="M15 22.75H9C3.57 22.75 1.25 20.43 1.25 15V9C1.25 3.57 3.57 1.25 9 1.25H15C20.43 1.25 22.75 3.57 22.75 9V15C22.75 20.43 20.43 22.75 15 22.75ZM9 2.75C4.39 2.75 2.75 4.39 2.75 9V15C2.75 19.61 4.39 21.25 9 21.25H15C19.61 21.25 21.25 19.61 21.25 15V9C21.25 4.39 19.61 2.75 15 2.75H9Z" fill="#667085"/>
                                </svg>
                                {{ __('My Proposals') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.ticket')) active @endif">
                            <a href="{{ route('freelancer.ticket') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_6522_7043" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0"
                                        y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="#D9D9D9" />
                                    </mask>
                                    <g mask="url(#mask0_6522_7043)">
                                        <path
                                            d="M12 22.5C11.8011 22.5 11.6103 22.421 11.4697 22.2803C11.329 22.1397 11.25 21.9489 11.25 21.75C11.25 21.5511 11.329 21.3603 11.4697 21.2197C11.6103 21.079 11.8011 21 12 21C14.3 21 16.16 20.3 16.9 19.5C16.1898 19.4692 15.5186 19.1666 15.0253 18.6547C14.5321 18.1428 14.2545 17.4609 14.25 16.75V13.75C14.2552 13.0223 14.5466 12.3258 15.0612 11.8112C15.5758 11.2966 16.2723 11.0052 17 11H18C18.4348 10.9971 18.8638 11.1001 19.25 11.3V10.75C19.25 9.79792 19.0625 8.85516 18.6981 7.97554C18.3338 7.09593 17.7997 6.2967 17.1265 5.62348C16.4533 4.95025 15.6541 4.41622 14.7745 4.05187C13.8948 3.68753 12.9521 3.5 12 3.5C11.0479 3.5 10.1052 3.68753 9.22554 4.05187C8.34593 4.41622 7.5467 4.95025 6.87348 5.62348C6.20025 6.2967 5.66622 7.09593 5.30187 7.97554C4.93753 8.85516 4.75 9.79792 4.75 10.75V11.3C5.13616 11.1001 5.56517 10.9971 6 11H7C7.72773 11.0052 8.42416 11.2966 8.93876 11.8112C9.45335 12.3258 9.74476 13.0223 9.75 13.75V16.75C9.74476 17.4777 9.45335 18.1742 8.93876 18.6888C8.42416 19.2034 7.72773 19.4948 7 19.5H6C5.27227 19.4948 4.57584 19.2034 4.06124 18.6888C3.54665 18.1742 3.25524 17.4777 3.25 16.75V10.75C3.25 8.42936 4.17187 6.20376 5.81282 4.56282C7.45376 2.92187 9.67936 2 12 2C14.3206 2 16.5462 2.92187 18.1872 4.56282C19.8281 6.20376 20.75 8.42936 20.75 10.75V16.75C20.7499 17.1109 20.6783 17.4681 20.5392 17.8011C20.4002 18.1341 20.1965 18.4362 19.94 18.69C19.5907 19.0543 19.1421 19.3081 18.65 19.42C18.11 21.22 15.43 22.5 12 22.5ZM17 12.5C16.6693 12.5026 16.3529 12.6352 16.119 12.869C15.8851 13.1029 15.7526 13.4193 15.75 13.75V16.75C15.7526 17.0807 15.8851 17.3971 16.119 17.631C16.3529 17.8649 16.6693 17.9974 17 18H18C18.3307 17.9974 18.6471 17.8649 18.881 17.631C19.1149 17.3971 19.2474 17.0807 19.25 16.75V13.75C19.2474 13.4193 19.1149 13.1029 18.881 12.869C18.6471 12.6352 18.3307 12.5026 18 12.5H17ZM4.75 13.75V16.75C4.75261 17.0807 4.88515 17.3971 5.11901 17.631C5.35286 17.8649 5.66929 17.9974 6 18H7C7.33071 17.9974 7.64714 17.8649 7.88099 17.631C8.11485 17.3971 8.24739 17.0807 8.25 16.75V13.75C8.24739 13.4193 8.11485 13.1029 7.88099 12.869C7.64714 12.6352 7.33071 12.5026 7 12.5H6C5.66929 12.5026 5.35286 12.6352 5.11901 12.869C4.88515 13.1029 4.75261 13.4193 4.75 13.75Z"
                                            fill="#667085" />
                                    </g>
                                </svg>
                                {{ __('Support tickets') }}
                            </a>
                        </li>
                        @if(moduleExists('StripeConnect'))
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.stripe.account')) active @endif">
                            <a href="{{ route('freelancer.stripe.account') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                        fill="#667085" />
                                    <path
                                        d="M6.19005 7.81044C5.95005 7.81044 5.73005 7.70044 5.58005 7.50044C5.41005 7.27044 5.39005 6.97044 5.52005 6.72044C5.69005 6.38044 5.93005 6.05044 6.24005 5.75044L9.49005 2.49043C11.15 0.84043 13.85 0.84043 15.51 2.49043L17.26 4.26045C18 4.99045 18.45 5.97045 18.5 7.01045C18.51 7.24045 18.42 7.46042 18.25 7.61042C18.08 7.76043 17.85 7.83045 17.63 7.79045C17.43 7.76045 17.22 7.75044 17 7.75044H7.00005C6.76005 7.75044 6.53005 7.77043 6.30005 7.80043C6.27005 7.81043 6.23005 7.81044 6.19005 7.81044ZM7.86005 6.25044H16.82C16.69 5.91044 16.48 5.60045 16.2 5.32045L14.44 3.54045C13.37 2.48045 11.62 2.48045 10.54 3.54045L7.86005 6.25044Z"
                                        fill="#667085" />
                                    <path
                                        d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Connect Bank Account') }}
                            </a>
                        </li>
                        @endif
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.wallet.history')) active @endif">
                            <a href="{{ route('freelancer.wallet.history') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                        fill="#667085" />
                                    <path
                                        d="M6.19005 7.81044C5.95005 7.81044 5.73005 7.70044 5.58005 7.50044C5.41005 7.27044 5.39005 6.97044 5.52005 6.72044C5.69005 6.38044 5.93005 6.05044 6.24005 5.75044L9.49005 2.49043C11.15 0.84043 13.85 0.84043 15.51 2.49043L17.26 4.26045C18 4.99045 18.45 5.97045 18.5 7.01045C18.51 7.24045 18.42 7.46042 18.25 7.61042C18.08 7.76043 17.85 7.83045 17.63 7.79045C17.43 7.76045 17.22 7.75044 17 7.75044H7.00005C6.76005 7.75044 6.53005 7.77043 6.30005 7.80043C6.27005 7.81043 6.23005 7.81044 6.19005 7.81044ZM7.86005 6.25044H16.82C16.69 5.91044 16.48 5.60045 16.2 5.32045L14.44 3.54045C13.37 2.48045 11.62 2.48045 10.54 3.54045L7.86005 6.25044Z"
                                        fill="#667085" />
                                    <path
                                        d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Wallet') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.wallet.withdraw.history')) active @endif">
                            <a href="{{ route('freelancer.wallet.withdraw.history') }}"
                                class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_6523_7035" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0"
                                        y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="#D9D9D9" />
                                    </mask>
                                    <g mask="url(#mask0_6523_7035)">
                                        <path
                                            d="M11.9793 21C10.4948 20.9991 9.03322 20.6344 7.72293 19.9382C6.36675 19.2152 5.21967 18.1564 4.39188 16.8635V19.4673C4.39188 19.6509 4.31876 19.8271 4.18862 19.9569C4.05847 20.0868 3.88196 20.1598 3.69791 20.1598C3.51386 20.1598 3.33734 20.0868 3.2072 19.9569C3.07705 19.8271 3.00394 19.6509 3.00394 19.4673V14.8506C3.00634 14.6677 3.08022 14.4929 3.20985 14.3636C3.33948 14.2342 3.5146 14.1605 3.69791 14.1581H8.32437C8.50842 14.1581 8.68493 14.2311 8.81508 14.3609C8.94522 14.4908 9.01834 14.6669 9.01834 14.8506C9.01834 15.0343 8.94522 15.2104 8.81508 15.3403C8.68493 15.4701 8.50842 15.5431 8.32437 15.5431H5.22464C6.07617 17.1672 7.48471 18.4314 9.19303 19.1049C10.9013 19.7784 12.7954 19.8163 14.5294 19.2116C16.2634 18.6069 17.7215 17.3999 18.6375 15.8112C19.5536 14.2225 19.8663 12.3579 19.5187 10.5581C19.1711 8.75833 18.1864 7.14334 16.7443 6.0081C15.3022 4.87286 13.499 4.29312 11.664 4.37476C9.82901 4.45641 8.08467 5.19398 6.74954 6.45278C5.41441 7.71158 4.57758 9.40761 4.39188 11.2311C4.37225 11.4148 4.2803 11.5832 4.13628 11.6992C3.99225 11.8152 3.80794 11.8694 3.62388 11.8498C3.43983 11.8302 3.27112 11.7384 3.15486 11.5947C3.03859 11.451 2.98431 11.2671 3.00394 11.0834C3.17277 9.44185 3.79051 7.87817 4.78966 6.56324C5.78881 5.24831 7.13093 4.23272 8.66936 3.62745C10.2078 3.02217 11.8834 2.8505 13.5129 3.13119C15.1425 3.41188 16.6635 4.13414 17.9095 5.21903C19.1556 6.30393 20.0789 7.70972 20.5785 9.2828C21.0781 10.8559 21.1347 12.5357 20.7423 14.1388C20.3499 15.7418 19.5235 17.2064 18.3533 18.3725C17.1832 19.5386 15.7144 20.3613 14.1074 20.7507C13.4101 20.9158 12.6959 20.9994 11.9793 21ZM13.8299 14.6198C13.7387 14.6202 13.6483 14.6025 13.5641 14.5676C13.4799 14.5327 13.4035 14.4814 13.3395 14.4166L11.4889 12.57C11.3587 12.4402 11.2855 12.2642 11.2853 12.0806V8.38728C11.2853 8.20362 11.3584 8.02748 11.4886 7.89761C11.6187 7.76774 11.7952 7.69478 11.9793 7.69478C12.1633 7.69478 12.3398 7.76774 12.47 7.89761C12.6001 8.02748 12.6732 8.20362 12.6732 8.38728V11.7944L14.3203 13.4379C14.4502 13.5678 14.5232 13.7438 14.5232 13.9273C14.5232 14.1108 14.4502 14.2868 14.3203 14.4166C14.2562 14.4814 14.1798 14.5327 14.0956 14.5676C14.0114 14.6025 13.921 14.6202 13.8299 14.6198Z"
                                            fill="#667085" />
                                    </g>
                                </svg>
                                {{ __('Withdraw History') }}
                            </a>
                        </li>
                        @if(get_static_option('subscription_enable_disable') != 'disable')
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.subscriptions.all')) active @endif">
                            <a href="{{ route('freelancer.subscriptions.all') }}"
                                class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M16.6999 19.7305H7.29994C6.55994 19.7305 5.80994 19.2005 5.55994 18.5105L1.41993 6.92047C0.909935 5.46047 1.27993 4.79047 1.67993 4.49047C2.07993 4.19047 2.82994 4.01047 4.08994 4.91047L7.98993 7.70047C8.10993 7.77047 8.21994 7.80047 8.29994 7.78047C8.38994 7.75047 8.45994 7.67047 8.50994 7.53047L10.2699 2.84047C10.7999 1.44047 11.5799 1.23047 11.9999 1.23047C12.4199 1.23047 13.1999 1.44047 13.7299 2.84047L15.4899 7.53047C15.5399 7.66047 15.6099 7.75047 15.6999 7.78047C15.7899 7.81047 15.8999 7.78047 16.0099 7.69047L19.6699 5.08047C21.0099 4.12047 21.7899 4.31047 22.2199 4.62047C22.6399 4.94047 23.0299 5.65047 22.4799 7.20047L18.4399 18.5105C18.1899 19.2005 17.4399 19.7305 16.6999 19.7305ZM2.67994 5.81047C2.69994 5.95047 2.73993 6.15047 2.83993 6.41047L6.97994 18.0005C7.01994 18.1005 7.19994 18.2305 7.29994 18.2305H16.6999C16.8099 18.2305 16.9899 18.1005 17.0199 18.0005L21.0599 6.70047C21.1999 6.32047 21.2399 6.06047 21.2499 5.91047C21.0999 5.96047 20.8699 6.07047 20.5399 6.31047L16.8799 8.92047C16.3799 9.27047 15.7899 9.38047 15.2599 9.22047C14.7299 9.06047 14.2999 8.64047 14.0799 8.07047L12.3199 3.38047C12.1899 3.03047 12.0699 2.86047 11.9999 2.78047C11.9299 2.86047 11.8099 3.03047 11.6799 3.37047L9.91994 8.06047C9.70994 8.63047 9.27993 9.05047 8.73993 9.21047C8.20993 9.37047 7.60994 9.26047 7.11994 8.91047L3.21994 6.12047C2.98994 5.96047 2.80994 5.86047 2.67994 5.81047Z"
                                        fill="#667085" />
                                    <path
                                        d="M17.5 22.75H6.5C6.09 22.75 5.75 22.41 5.75 22C5.75 21.59 6.09 21.25 6.5 21.25H17.5C17.91 21.25 18.25 21.59 18.25 22C18.25 22.41 17.91 22.75 17.5 22.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M14.5 14.75H9.5C9.09 14.75 8.75 14.41 8.75 14C8.75 13.59 9.09 13.25 9.5 13.25H14.5C14.91 13.25 15.25 13.59 15.25 14C15.25 14.41 14.91 14.75 14.5 14.75Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Subscriptions') }}
                            </a>
                        </li>
                        @endif
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.live.chat')) active @endif">
                            <a href="{{ route('freelancer.live.chat') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <mask id="mask0_6522_7114" style="mask-type:alpha" maskUnits="userSpaceOnUse"
                                        x="0" y="0" width="24" height="24">
                                        <rect width="24" height="24" fill="#D9D9D9" />
                                    </mask>
                                    <g mask="url(#mask0_6522_7114)">
                                        <path
                                            d="M2.98121 20.7488C2.87552 20.749 2.771 20.7268 2.67449 20.6837C2.57798 20.6406 2.49167 20.5776 2.42121 20.4988C2.33208 20.4003 2.27112 20.2796 2.24473 20.1494C2.21834 20.0192 2.22748 19.8843 2.27121 19.7588L3.45121 16.1988C2.35425 14.3826 2.00494 12.2116 2.47686 10.143C2.94879 8.07433 4.2051 6.26958 5.98121 5.10883C7.87969 3.80773 10.148 3.15537 12.4476 3.24909C14.7472 3.3428 16.9549 4.17757 18.7412 5.62883C19.5817 6.30768 20.2784 7.14724 20.7907 8.09846C21.303 9.04967 21.6206 10.0935 21.7249 11.1688C21.8291 12.2442 21.718 13.3295 21.3981 14.3614C21.0781 15.3933 20.5556 16.3511 19.8612 17.1788C18.3665 18.8724 16.3667 20.0404 14.1573 20.5104C11.9479 20.9803 9.64586 20.7274 7.59121 19.7888L3.14121 20.7288L2.98121 20.7488ZM7.68121 18.2488C7.79567 18.2516 7.9082 18.2789 8.01121 18.3288C9.77535 19.1905 11.7729 19.4517 13.6992 19.0726C15.6256 18.6934 17.3752 17.6948 18.6812 16.2288C19.2483 15.5503 19.6743 14.7654 19.9343 13.9202C20.1943 13.075 20.2832 12.1864 20.1957 11.3064C20.1081 10.4265 19.846 9.57279 19.4245 8.79537C19.0031 8.01795 18.4308 7.3324 17.7412 6.77883C16.2119 5.53354 14.3201 4.81756 12.3495 4.73823C10.3789 4.6589 8.43568 5.2205 6.81121 6.33883C6.06825 6.82298 5.42879 7.4498 4.92992 8.18295C4.43104 8.91611 4.08267 9.741 3.905 10.6098C3.72733 11.4786 3.7239 12.374 3.89491 13.2442C4.06592 14.1143 4.40796 14.9419 4.90121 15.6788C4.96467 15.7751 5.0057 15.8844 5.02127 15.9986C5.03685 16.1128 5.02658 16.2291 4.99121 16.3388L4.11121 18.9988L7.52121 18.2788L7.68121 18.2488Z"
                                            fill="#667085" />
                                    </g>
                                </svg>
                                {{ __('Live Chat') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.profile')) active @endif">
                            <a href="{{ route('freelancer.profile') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12 15.75C9.93 15.75 8.25 14.07 8.25 12C8.25 9.93 9.93 8.25 12 8.25C14.07 8.25 15.75 9.93 15.75 12C15.75 14.07 14.07 15.75 12 15.75ZM12 9.75C10.76 9.75 9.75 10.76 9.75 12C9.75 13.24 10.76 14.25 12 14.25C13.24 14.25 14.25 13.24 14.25 12C14.25 10.76 13.24 9.75 12 9.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M15.21 22.1903C15 22.1903 14.79 22.1603 14.58 22.1103C13.96 21.9403 13.44 21.5503 13.11 21.0003L12.99 20.8003C12.4 19.7803 11.59 19.7803 11 20.8003L10.89 20.9903C10.56 21.5503 10.04 21.9503 9.42 22.1103C8.79 22.2803 8.14 22.1903 7.59 21.8603L5.87 20.8703C5.26 20.5203 4.82 19.9503 4.63 19.2603C4.45 18.5703 4.54 17.8603 4.89 17.2503C5.18 16.7403 5.26 16.2803 5.09 15.9903C4.92 15.7003 4.49 15.5303 3.9 15.5303C2.44 15.5303 1.25 14.3403 1.25 12.8803V11.1203C1.25 9.66029 2.44 8.47029 3.9 8.47029C4.49 8.47029 4.92 8.30029 5.09 8.01029C5.26 7.72029 5.19 7.26029 4.89 6.75029C4.54 6.14029 4.45 5.42029 4.63 4.74029C4.81 4.05029 5.25 3.48029 5.87 3.13029L7.6 2.14029C8.73 1.47029 10.22 1.86029 10.9 3.01029L11.02 3.21029C11.61 4.23029 12.42 4.23029 13.01 3.21029L13.12 3.02029C13.8 1.86029 15.29 1.47029 16.43 2.15029L18.15 3.14029C18.76 3.49029 19.2 4.06029 19.39 4.75029C19.57 5.44029 19.48 6.15029 19.13 6.76029C18.84 7.27029 18.76 7.73029 18.93 8.02029C19.1 8.31029 19.53 8.48029 20.12 8.48029C21.58 8.48029 22.77 9.67029 22.77 11.1303V12.8903C22.77 14.3503 21.58 15.5403 20.12 15.5403C19.53 15.5403 19.1 15.7103 18.93 16.0003C18.76 16.2903 18.83 16.7503 19.13 17.2603C19.48 17.8703 19.58 18.5903 19.39 19.2703C19.21 19.9603 18.77 20.5303 18.15 20.8803L16.42 21.8703C16.04 22.0803 15.63 22.1903 15.21 22.1903ZM12 18.4903C12.89 18.4903 13.72 19.0503 14.29 20.0403L14.4 20.2303C14.52 20.4403 14.72 20.5903 14.96 20.6503C15.2 20.7103 15.44 20.6803 15.64 20.5603L17.37 19.5603C17.63 19.4103 17.83 19.1603 17.91 18.8603C17.99 18.5603 17.95 18.2503 17.8 17.9903C17.23 17.0103 17.16 16.0003 17.6 15.2303C18.04 14.4603 18.95 14.0203 20.09 14.0203C20.73 14.0203 21.24 13.5103 21.24 12.8703V11.1103C21.24 10.4803 20.73 9.96029 20.09 9.96029C18.95 9.96029 18.04 9.52029 17.6 8.75029C17.16 7.98029 17.23 6.97029 17.8 5.99029C17.95 5.73029 17.99 5.42029 17.91 5.12029C17.83 4.82029 17.64 4.58029 17.38 4.42029L15.65 3.43029C15.22 3.17029 14.65 3.32029 14.39 3.76029L14.28 3.95029C13.71 4.94029 12.88 5.50029 11.99 5.50029C11.1 5.50029 10.27 4.94029 9.7 3.95029L9.59 3.75029C9.34 3.33029 8.78 3.18029 8.35 3.43029L6.62 4.43029C6.36 4.58029 6.16 4.83029 6.08 5.13029C6 5.43029 6.04 5.74029 6.19 6.00029C6.76 6.98029 6.83 7.99029 6.39 8.76029C5.95 9.53029 5.04 9.97029 3.9 9.97029C3.26 9.97029 2.75 10.4803 2.75 11.1203V12.8803C2.75 13.5103 3.26 14.0303 3.9 14.0303C5.04 14.0303 5.95 14.4703 6.39 15.2403C6.83 16.0103 6.76 17.0203 6.19 18.0003C6.04 18.2603 6 18.5703 6.08 18.8703C6.16 19.1703 6.35 19.4103 6.61 19.5703L8.34 20.5603C8.55 20.6903 8.8 20.7203 9.03 20.6603C9.27 20.6003 9.47 20.4403 9.6 20.2303L9.71 20.0403C10.28 19.0603 11.11 18.4903 12 18.4903Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Profile Settings') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.account.setup') }}"
                                class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12 12.75C8.83 12.75 6.25 10.17 6.25 7C6.25 3.83 8.83 1.25 12 1.25C15.17 1.25 17.75 3.83 17.75 7C17.75 10.17 15.17 12.75 12 12.75ZM12 2.75C9.66 2.75 7.75 4.66 7.75 7C7.75 9.34 9.66 11.25 12 11.25C14.34 11.25 16.25 9.34 16.25 7C16.25 4.66 14.34 2.75 12 2.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M15.8201 22.7504C15.4401 22.7504 15.0801 22.6103 14.8201 22.3503C14.5101 22.0403 14.3701 21.5904 14.4401 21.1204L14.6301 19.7704C14.6801 19.4204 14.8901 19.0104 15.1401 18.7504L18.68 15.2104C20.1 13.7904 21.3501 14.6004 21.9601 15.2104C22.4801 15.7304 22.7501 16.2903 22.7501 16.8503C22.7501 17.4203 22.4901 17.9503 21.9601 18.4803L18.42 22.0204C18.17 22.2704 17.7501 22.4804 17.4001 22.5304L16.05 22.7203C15.97 22.7403 15.9001 22.7504 15.8201 22.7504ZM20.31 15.9203C20.13 15.9203 19.97 16.0404 19.74 16.2704L16.2001 19.8104C16.1701 19.8404 16.12 19.9403 16.12 19.9803L15.9401 21.2303L17.1901 21.0504C17.2301 21.0404 17.33 20.9904 17.36 20.9604L20.9001 17.4203C21.0601 17.2603 21.2501 17.0303 21.2501 16.8503C21.2501 16.7003 21.1301 16.4904 20.9001 16.2704C20.6601 16.0304 20.48 15.9203 20.31 15.9203Z"
                                        fill="#667085" />
                                    <path
                                        d="M20.9201 19.2203C20.8501 19.2203 20.7801 19.2104 20.7201 19.1904C19.4001 18.8204 18.3501 17.7704 17.9801 16.4504C17.8701 16.0504 18.1001 15.6404 18.5001 15.5304C18.9001 15.4204 19.3101 15.6503 19.4201 16.0503C19.6501 16.8703 20.3001 17.5204 21.1201 17.7504C21.5201 17.8604 21.7501 18.2803 21.6401 18.6703C21.5501 19.0003 21.2501 19.2203 20.9201 19.2203Z"
                                        fill="#667085" />
                                    <path
                                        d="M3.41016 22.75C3.00016 22.75 2.66016 22.41 2.66016 22C2.66016 17.73 6.85018 14.25 12.0002 14.25C13.0902 14.25 14.1702 14.41 15.1802 14.71C15.5802 14.83 15.8002 15.25 15.6802 15.64C15.5602 16.04 15.1402 16.26 14.7502 16.14C13.8702 15.88 12.9502 15.74 12.0002 15.74C7.68018 15.74 4.16016 18.54 4.16016 21.99C4.16016 22.41 3.82016 22.75 3.41016 22.75Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Account Setup') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer.identity.verification')) active @endif">
                            <a href="{{ route('freelancer.identity.verification') }}"
                                class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M17 21.75H7C2.59 21.75 1.25 20.41 1.25 16V8C1.25 3.59 2.59 2.25 7 2.25H17C21.41 2.25 22.75 3.59 22.75 8V16C22.75 20.41 21.41 21.75 17 21.75ZM7 3.75C3.42 3.75 2.75 4.43 2.75 8V16C2.75 19.57 3.42 20.25 7 20.25H17C20.58 20.25 21.25 19.57 21.25 16V8C21.25 4.43 20.58 3.75 17 3.75H7Z"
                                        fill="#667085" />
                                    <path
                                        d="M19 8.75H14C13.59 8.75 13.25 8.41 13.25 8C13.25 7.59 13.59 7.25 14 7.25H19C19.41 7.25 19.75 7.59 19.75 8C19.75 8.41 19.41 8.75 19 8.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M19 12.75H15C14.59 12.75 14.25 12.41 14.25 12C14.25 11.59 14.59 11.25 15 11.25H19C19.41 11.25 19.75 11.59 19.75 12C19.75 12.41 19.41 12.75 19 12.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M19 16.75H17C16.59 16.75 16.25 16.41 16.25 16C16.25 15.59 16.59 15.25 17 15.25H19C19.41 15.25 19.75 15.59 19.75 16C19.75 16.41 19.41 16.75 19 16.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M8.4975 12.04C7.0875 12.04 5.9375 10.89 5.9375 9.47998C5.9375 8.06998 7.0875 6.91998 8.4975 6.91998C9.9075 6.91998 11.0575 8.06998 11.0575 9.47998C11.0575 10.89 9.9075 12.04 8.4975 12.04ZM8.4975 8.41998C7.9175 8.41998 7.4375 8.89998 7.4375 9.47998C7.4375 10.06 7.9175 10.54 8.4975 10.54C9.0775 10.54 9.5575 10.06 9.5575 9.47998C9.5575 8.89998 9.0775 8.41998 8.4975 8.41998Z"
                                        fill="#667085" />
                                    <path
                                        d="M11.998 17.08C11.618 17.08 11.288 16.79 11.248 16.4C11.138 15.32 10.268 14.45 9.17795 14.35C8.71795 14.31 8.25795 14.31 7.79795 14.35C6.70795 14.45 5.83795 15.31 5.72795 16.4C5.68795 16.81 5.31795 17.12 4.90795 17.07C4.49795 17.03 4.19795 16.66 4.23795 16.25C4.41795 14.45 5.84795 13.02 7.65795 12.86C8.20795 12.81 8.76795 12.81 9.31795 12.86C11.118 13.03 12.558 14.46 12.738 16.25C12.778 16.66 12.478 17.03 12.068 17.07C12.048 17.08 12.018 17.08 11.998 17.08Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Identity Verification') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item @if (request()->routeIs('freelancer._2fa')) active @endif">
                            <a href="{{ route('freelancer._2fa') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M11.9984 22.76C10.9084 22.76 9.82844 22.44 8.97844 21.81L4.67844 18.6C3.53844 17.75 2.64844 15.97 2.64844 14.56V7.12C2.64844 5.58 3.77844 3.94 5.22844 3.4L10.2184 1.53C11.2084 1.16 12.7684 1.16 13.7584 1.53L18.7484 3.4C20.1984 3.94 21.3284 5.58 21.3284 7.12V14.55C21.3284 15.97 20.4384 17.74 19.2984 18.59L14.9984 21.8C14.1684 22.44 13.0884 22.76 11.9984 22.76ZM10.7484 2.94L5.75844 4.81C4.90844 5.13 4.15844 6.21 4.15844 7.13V14.56C4.15844 15.51 4.82844 16.84 5.57844 17.4L9.87844 20.61C11.0284 21.47 12.9684 21.47 14.1284 20.61L18.4284 17.4C19.1884 16.83 19.8484 15.51 19.8484 14.56V7.12C19.8484 6.21 19.0984 5.13 18.2484 4.8L13.2584 2.93C12.5784 2.69 11.4184 2.69 10.7484 2.94Z"
                                        fill="#667085" />
                                    <path
                                        d="M10.6622 14.23C10.4722 14.23 10.2822 14.16 10.1322 14.01L8.52219 12.4C8.23219 12.11 8.23219 11.63 8.52219 11.34C8.81219 11.05 9.29219 11.05 9.58219 11.34L10.6622 12.42L14.4322 8.65C14.7222 8.36 15.2022 8.36 15.4922 8.65C15.7822 8.94 15.7822 9.42 15.4922 9.71L11.1922 14.01C11.0422 14.16 10.8522 14.23 10.6622 14.23Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('2 Factor Authentication') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.profile.details', Auth::guard('web')->user()->username) }}"
                                class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12.12 13.5305C12.1 13.5305 12.07 13.5305 12.05 13.5305C12.02 13.5305 11.98 13.5305 11.95 13.5305C9.67998 13.4605 7.97998 11.6905 7.97998 9.51047C7.97998 7.29047 9.78998 5.48047 12.01 5.48047C14.23 5.48047 16.04 7.29047 16.04 9.51047C16.03 11.7005 14.32 13.4605 12.15 13.5305C12.13 13.5305 12.13 13.5305 12.12 13.5305ZM12 6.97047C10.6 6.97047 9.46998 8.11047 9.46998 9.50047C9.46998 10.8705 10.54 11.9805 11.9 12.0305C11.93 12.0205 12.03 12.0205 12.13 12.0305C13.47 11.9605 14.52 10.8605 14.53 9.50047C14.53 8.11047 13.4 6.97047 12 6.97047Z"
                                        fill="#667085" />
                                    <path
                                        d="M12.0001 22.7503C9.31008 22.7503 6.74008 21.7503 4.75008 19.9303C4.57008 19.7703 4.49008 19.5303 4.51008 19.3003C4.64008 18.1103 5.38008 17.0003 6.61008 16.1803C9.59008 14.2003 14.4201 14.2003 17.3901 16.1803C18.6201 17.0103 19.3601 18.1103 19.4901 19.3003C19.5201 19.5403 19.4301 19.7703 19.2501 19.9303C17.2601 21.7503 14.6901 22.7503 12.0001 22.7503ZM6.08008 19.1003C7.74008 20.4903 9.83008 21.2503 12.0001 21.2503C14.1701 21.2503 16.2601 20.4903 17.9201 19.1003C17.7401 18.4903 17.2601 17.9003 16.5501 17.4203C14.0901 15.7803 9.92008 15.7803 7.44008 17.4203C6.73008 17.9003 6.26008 18.4903 6.08008 19.1003Z"
                                        fill="#667085" />
                                    <path
                                        d="M12 22.75C6.07 22.75 1.25 17.93 1.25 12C1.25 6.07 6.07 1.25 12 1.25C17.93 1.25 22.75 6.07 22.75 12C22.75 17.93 17.93 22.75 12 22.75ZM12 2.75C6.9 2.75 2.75 6.9 2.75 12C2.75 17.1 6.9 21.25 12 21.25C17.1 21.25 21.25 17.1 21.25 12C21.25 6.9 17.1 2.75 12 2.75Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Profile Details') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.password') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M18 10.75C17.59 10.75 17.25 10.41 17.25 10V8C17.25 4.85 16.36 2.75 12 2.75C7.64 2.75 6.75 4.85 6.75 8V10C6.75 10.41 6.41 10.75 6 10.75C5.59 10.75 5.25 10.41 5.25 10V8C5.25 5.1 5.95 1.25 12 1.25C18.05 1.25 18.75 5.1 18.75 8V10C18.75 10.41 18.41 10.75 18 10.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M12 19.25C10.21 19.25 8.75 17.79 8.75 16C8.75 14.21 10.21 12.75 12 12.75C13.79 12.75 15.25 14.21 15.25 16C15.25 17.79 13.79 19.25 12 19.25ZM12 14.25C11.04 14.25 10.25 15.04 10.25 16C10.25 16.96 11.04 17.75 12 17.75C12.96 17.75 13.75 16.96 13.75 16C13.75 15.04 12.96 14.25 12 14.25Z"
                                        fill="#667085" />
                                    <path
                                        d="M17 22.75H7C2.59 22.75 1.25 21.41 1.25 17V15C1.25 10.59 2.59 9.25 7 9.25H17C21.41 9.25 22.75 10.59 22.75 15V17C22.75 21.41 21.41 22.75 17 22.75ZM7 10.75C3.42 10.75 2.75 11.43 2.75 15V17C2.75 20.57 3.42 21.25 7 21.25H17C20.58 21.25 21.25 20.57 21.25 17V15C21.25 11.43 20.58 10.75 17 10.75H7Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Change Password') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.account.delete') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path
                                            d="M15.24 22.2705H15.11C10.67 22.2705 8.53002 20.5205 8.16002 16.6005C8.12002 16.1905 8.42002 15.8205 8.84002 15.7805C9.24002 15.7405 9.62002 16.0505 9.66002 16.4605C9.95002 19.6005 11.43 20.7705 15.12 20.7705H15.25C19.32 20.7705 20.76 19.3305 20.76 15.2605V8.74047C20.76 4.67047 19.32 3.23047 15.25 3.23047H15.12C11.41 3.23047 9.93002 4.42047 9.66002 7.62047C9.61002 8.03047 9.26002 8.34047 8.84002 8.30047C8.42002 8.27047 8.12001 7.90047 8.15001 7.49047C8.49001 3.51047 10.64 1.73047 15.11 1.73047H15.24C20.15 1.73047 22.25 3.83047 22.25 8.74047V15.2605C22.25 20.1705 20.15 22.2705 15.24 22.2705Z"
                                            fill="#667085" />
                                    <path
                                            d="M15.0001 12.75H3.62012C3.21012 12.75 2.87012 12.41 2.87012 12C2.87012 11.59 3.21012 11.25 3.62012 11.25H15.0001C15.4101 11.25 15.7501 11.59 15.7501 12C15.7501 12.41 15.4101 12.75 15.0001 12.75Z"
                                            fill="#667085" />
                                    <path
                                            d="M5.84994 16.0998C5.65994 16.0998 5.46994 16.0298 5.31994 15.8798L1.96994 12.5298C1.67994 12.2398 1.67994 11.7598 1.96994 11.4698L5.31994 8.11984C5.60994 7.82984 6.08994 7.82984 6.37994 8.11984C6.66994 8.40984 6.66994 8.88984 6.37994 9.17984L3.55994 11.9998L6.37994 14.8198C6.66994 15.1098 6.66994 15.5898 6.37994 15.8798C6.23994 16.0298 6.03994 16.0998 5.84994 16.0998Z"
                                            fill="#667085" />
                                </svg>
                                {{ __('Account Delete') }}
                            </a>
                        </li>
                        <li class="profile-settings-menu-item">
                            <a href="{{ route('freelancer.logout') }}" class="profile-settings-menu-item-link">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M15.24 22.2705H15.11C10.67 22.2705 8.53002 20.5205 8.16002 16.6005C8.12002 16.1905 8.42002 15.8205 8.84002 15.7805C9.24002 15.7405 9.62002 16.0505 9.66002 16.4605C9.95002 19.6005 11.43 20.7705 15.12 20.7705H15.25C19.32 20.7705 20.76 19.3305 20.76 15.2605V8.74047C20.76 4.67047 19.32 3.23047 15.25 3.23047H15.12C11.41 3.23047 9.93002 4.42047 9.66002 7.62047C9.61002 8.03047 9.26002 8.34047 8.84002 8.30047C8.42002 8.27047 8.12001 7.90047 8.15001 7.49047C8.49001 3.51047 10.64 1.73047 15.11 1.73047H15.24C20.15 1.73047 22.25 3.83047 22.25 8.74047V15.2605C22.25 20.1705 20.15 22.2705 15.24 22.2705Z"
                                        fill="#667085" />
                                    <path
                                        d="M15.0001 12.75H3.62012C3.21012 12.75 2.87012 12.41 2.87012 12C2.87012 11.59 3.21012 11.25 3.62012 11.25H15.0001C15.4101 11.25 15.7501 11.59 15.7501 12C15.7501 12.41 15.4101 12.75 15.0001 12.75Z"
                                        fill="#667085" />
                                    <path
                                        d="M5.84994 16.0998C5.65994 16.0998 5.46994 16.0298 5.31994 15.8798L1.96994 12.5298C1.67994 12.2398 1.67994 11.7598 1.96994 11.4698L5.31994 8.11984C5.60994 7.82984 6.08994 7.82984 6.37994 8.11984C6.66994 8.40984 6.66994 8.88984 6.37994 9.17984L3.55994 11.9998L6.37994 14.8198C6.66994 15.1098 6.66994 15.5898 6.37994 15.8798C6.23994 16.0298 6.03994 16.0998 5.84994 16.0998Z"
                                        fill="#667085" />
                                </svg>
                                {{ __('Log Out') }}
                            </a>
                        </li>
                    </ul>
                    @endif
                @else
                    @if(Session::get('user_role') == 'freelancer')
                       @include('frontend.user.layout.partials.act-as-freelancer-sidebar')
                    @else
                        <ul class="profile-settings-menu-list">
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.dashboard')) active @endif">
                                <a href="{{ route('client.dashboard') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7 10.75H5C2.58 10.75 1.25 9.42 1.25 7V5C1.25 2.58 2.58 1.25 5 1.25H7C9.42 1.25 10.75 2.58 10.75 5V7C10.75 9.42 9.42 10.75 7 10.75ZM5 2.75C3.42 2.75 2.75 3.42 2.75 5V7C2.75 8.58 3.42 9.25 5 9.25H7C8.58 9.25 9.25 8.58 9.25 7V5C9.25 3.42 8.58 2.75 7 2.75H5Z" fill="#667085"/>
                                        <path d="M19 10.75H17C14.58 10.75 13.25 9.42 13.25 7V5C13.25 2.58 14.58 1.25 17 1.25H19C21.42 1.25 22.75 2.58 22.75 5V7C22.75 9.42 21.42 10.75 19 10.75ZM17 2.75C15.42 2.75 14.75 3.42 14.75 5V7C14.75 8.58 15.42 9.25 17 9.25H19C20.58 9.25 21.25 8.58 21.25 7V5C21.25 3.42 20.58 2.75 19 2.75H17Z" fill="#667085"/>
                                        <path d="M19 22.75H17C14.58 22.75 13.25 21.42 13.25 19V17C13.25 14.58 14.58 13.25 17 13.25H19C21.42 13.25 22.75 14.58 22.75 17V19C22.75 21.42 21.42 22.75 19 22.75ZM17 14.75C15.42 14.75 14.75 15.42 14.75 17V19C14.75 20.58 15.42 21.25 17 21.25H19C20.58 21.25 21.25 20.58 21.25 19V17C21.25 15.42 20.58 14.75 19 14.75H17Z" fill="#667085"/>
                                        <path d="M7 22.75H5C2.58 22.75 1.25 21.42 1.25 19V17C1.25 14.58 2.58 13.25 5 13.25H7C9.42 13.25 10.75 14.58 10.75 17V19C10.75 21.42 9.42 22.75 7 22.75ZM5 14.75C3.42 14.75 2.75 15.42 2.75 17V19C2.75 20.58 3.42 21.25 5 21.25H7C8.58 21.25 9.25 20.58 9.25 19V17C9.25 15.42 8.58 14.75 7 14.75H5Z" fill="#667085"/>
                                    </svg>
                                    {{ __('Dashboard') }}
                                </a>
                            </li>
                            @if(moduleExists('SecurityManage'))
                                @if(Auth::guard('web')->user()->freeze_job == 'freeze')
                                    <li class="profile-settings-menu-item @if(Auth::guard('web')->user()->freeze_job == 'freeze') disabled-link @endif">
                                        <a href="#" class="profile-settings-menu-item-link">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                        d="M15.812 20.18C15.552 20.18 15.282 20.17 14.992 20.14C14.472 20.1 13.882 20 13.272 19.85L11.592 19.45C6.98203 18.36 5.47203 15.92 6.55203 11.32L7.53203 7.13001C7.75203 6.18001 8.01202 5.41001 8.33202 4.77002C10.052 1.22002 13.342 1.54001 15.682 2.09001L17.352 2.48001C19.692 3.03001 21.172 3.90001 22.002 5.23002C22.822 6.56002 22.952 8.27002 22.402 10.61L21.422 14.79C20.562 18.45 18.772 20.18 15.812 20.18ZM13.122 3.25001C11.452 3.25001 10.392 3.94002 9.68203 5.42002C9.42203 5.96002 9.19202 6.63001 8.99202 7.47001L8.01203 11.66C7.12203 15.44 8.15203 17.09 11.932 17.99L13.612 18.39C14.152 18.52 14.662 18.6 15.122 18.64C17.842 18.91 19.192 17.72 19.952 14.45L20.932 10.27C21.382 8.34002 21.322 6.99001 20.722 6.02001C20.122 5.05001 18.942 4.39002 17.002 3.94002L15.332 3.55001C14.502 3.35001 13.762 3.25001 13.122 3.25001Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M8.32907 22.25C5.75907 22.25 4.11907 20.71 3.06907 17.46L1.78907 13.5101C0.369075 9.11005 1.63907 6.63005 6.01907 5.21005L7.59907 4.70005C8.11907 4.54005 8.50907 4.43005 8.85907 4.37005C9.14907 4.31005 9.42908 4.42005 9.59908 4.65005C9.76908 4.88005 9.79908 5.18005 9.67908 5.44005C9.41908 5.97005 9.18907 6.64005 8.99907 7.48005L8.01908 11.6701C7.12908 15.4501 8.15907 17.1001 11.9391 18.0001L13.6191 18.4001C14.1591 18.5301 14.6691 18.6101 15.1291 18.6501C15.4491 18.6801 15.7091 18.9 15.7991 19.21C15.8791 19.52 15.7591 19.8401 15.4991 20.0201C14.8391 20.4701 14.0091 20.8501 12.9591 21.1901L11.3791 21.71C10.2291 22.07 9.22907 22.25 8.32907 22.25ZM7.77908 6.22005L6.48907 6.64005C2.91907 7.79005 2.06907 9.47005 3.21907 13.0501L4.49907 17.0001C5.65907 20.5701 7.33907 21.4301 10.9091 20.2801L12.4891 19.7601C12.5491 19.7401 12.5991 19.7201 12.6591 19.7001L11.5991 19.4501C6.98908 18.3601 5.47907 15.9201 6.55907 11.3201L7.53907 7.13005C7.60907 6.81005 7.68908 6.50005 7.77908 6.22005Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M17.4933 10.51C17.4333 10.51 17.3733 10.5 17.3033 10.49L12.4533 9.26002C12.0533 9.16002 11.8133 8.75002 11.9133 8.35002C12.0133 7.95002 12.4233 7.71002 12.8233 7.81002L17.6733 9.04002C18.0733 9.14002 18.3133 9.55002 18.2133 9.95002C18.1333 10.28 17.8233 10.51 17.4933 10.51Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M14.5611 13.89C14.5011 13.89 14.4411 13.88 14.3711 13.87L11.4611 13.13C11.0611 13.03 10.8211 12.62 10.9211 12.22C11.0211 11.82 11.4311 11.58 11.8311 11.68L14.7411 12.42C15.1411 12.52 15.3811 12.93 15.2811 13.33C15.2011 13.67 14.9011 13.89 14.5611 13.89Z"
                                                        fill="#667085" />
                                            </svg>
                                            {{ __('Post a Job') }}
                                        </a>
                                    </li>
                                @else
                                    @if(get_static_option('job_enable_disable') != 'disable')
                                        <li class="profile-settings-menu-item">
                                            <a href="{{ route('client.job.create') }}" class="profile-settings-menu-item-link">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                     xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                            d="M15.812 20.18C15.552 20.18 15.282 20.17 14.992 20.14C14.472 20.1 13.882 20 13.272 19.85L11.592 19.45C6.98203 18.36 5.47203 15.92 6.55203 11.32L7.53203 7.13001C7.75203 6.18001 8.01202 5.41001 8.33202 4.77002C10.052 1.22002 13.342 1.54001 15.682 2.09001L17.352 2.48001C19.692 3.03001 21.172 3.90001 22.002 5.23002C22.822 6.56002 22.952 8.27002 22.402 10.61L21.422 14.79C20.562 18.45 18.772 20.18 15.812 20.18ZM13.122 3.25001C11.452 3.25001 10.392 3.94002 9.68203 5.42002C9.42203 5.96002 9.19202 6.63001 8.99202 7.47001L8.01203 11.66C7.12203 15.44 8.15203 17.09 11.932 17.99L13.612 18.39C14.152 18.52 14.662 18.6 15.122 18.64C17.842 18.91 19.192 17.72 19.952 14.45L20.932 10.27C21.382 8.34002 21.322 6.99001 20.722 6.02001C20.122 5.05001 18.942 4.39002 17.002 3.94002L15.332 3.55001C14.502 3.35001 13.762 3.25001 13.122 3.25001Z"
                                                            fill="#667085" />
                                                    <path
                                                            d="M8.32907 22.25C5.75907 22.25 4.11907 20.71 3.06907 17.46L1.78907 13.5101C0.369075 9.11005 1.63907 6.63005 6.01907 5.21005L7.59907 4.70005C8.11907 4.54005 8.50907 4.43005 8.85907 4.37005C9.14907 4.31005 9.42908 4.42005 9.59908 4.65005C9.76908 4.88005 9.79908 5.18005 9.67908 5.44005C9.41908 5.97005 9.18907 6.64005 8.99907 7.48005L8.01908 11.6701C7.12908 15.4501 8.15907 17.1001 11.9391 18.0001L13.6191 18.4001C14.1591 18.5301 14.6691 18.6101 15.1291 18.6501C15.4491 18.6801 15.7091 18.9 15.7991 19.21C15.8791 19.52 15.7591 19.8401 15.4991 20.0201C14.8391 20.4701 14.0091 20.8501 12.9591 21.1901L11.3791 21.71C10.2291 22.07 9.22907 22.25 8.32907 22.25ZM7.77908 6.22005L6.48907 6.64005C2.91907 7.79005 2.06907 9.47005 3.21907 13.0501L4.49907 17.0001C5.65907 20.5701 7.33907 21.4301 10.9091 20.2801L12.4891 19.7601C12.5491 19.7401 12.5991 19.7201 12.6591 19.7001L11.5991 19.4501C6.98908 18.3601 5.47907 15.9201 6.55907 11.3201L7.53907 7.13005C7.60907 6.81005 7.68908 6.50005 7.77908 6.22005Z"
                                                            fill="#667085" />
                                                    <path
                                                            d="M17.4933 10.51C17.4333 10.51 17.3733 10.5 17.3033 10.49L12.4533 9.26002C12.0533 9.16002 11.8133 8.75002 11.9133 8.35002C12.0133 7.95002 12.4233 7.71002 12.8233 7.81002L17.6733 9.04002C18.0733 9.14002 18.3133 9.55002 18.2133 9.95002C18.1333 10.28 17.8233 10.51 17.4933 10.51Z"
                                                            fill="#667085" />
                                                    <path
                                                            d="M14.5611 13.89C14.5011 13.89 14.4411 13.88 14.3711 13.87L11.4611 13.13C11.0611 13.03 10.8211 12.62 10.9211 12.22C11.0211 11.82 11.4311 11.58 11.8311 11.68L14.7411 12.42C15.1411 12.52 15.3811 12.93 15.2811 13.33C15.2011 13.67 14.9011 13.89 14.5611 13.89Z"
                                                            fill="#667085" />
                                                </svg>
                                                {{ __('Post a Job') }}
                                            </a>
                                        </li>
                                    @endif
                                @endif
                            @else
                                @if(get_static_option('job_enable_disable') != 'disable')
                                    <li class="profile-settings-menu-item">
                                        <a href="{{ route('client.job.create') }}" class="profile-settings-menu-item-link">
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                        d="M15.812 20.18C15.552 20.18 15.282 20.17 14.992 20.14C14.472 20.1 13.882 20 13.272 19.85L11.592 19.45C6.98203 18.36 5.47203 15.92 6.55203 11.32L7.53203 7.13001C7.75203 6.18001 8.01202 5.41001 8.33202 4.77002C10.052 1.22002 13.342 1.54001 15.682 2.09001L17.352 2.48001C19.692 3.03001 21.172 3.90001 22.002 5.23002C22.822 6.56002 22.952 8.27002 22.402 10.61L21.422 14.79C20.562 18.45 18.772 20.18 15.812 20.18ZM13.122 3.25001C11.452 3.25001 10.392 3.94002 9.68203 5.42002C9.42203 5.96002 9.19202 6.63001 8.99202 7.47001L8.01203 11.66C7.12203 15.44 8.15203 17.09 11.932 17.99L13.612 18.39C14.152 18.52 14.662 18.6 15.122 18.64C17.842 18.91 19.192 17.72 19.952 14.45L20.932 10.27C21.382 8.34002 21.322 6.99001 20.722 6.02001C20.122 5.05001 18.942 4.39002 17.002 3.94002L15.332 3.55001C14.502 3.35001 13.762 3.25001 13.122 3.25001Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M8.32907 22.25C5.75907 22.25 4.11907 20.71 3.06907 17.46L1.78907 13.5101C0.369075 9.11005 1.63907 6.63005 6.01907 5.21005L7.59907 4.70005C8.11907 4.54005 8.50907 4.43005 8.85907 4.37005C9.14907 4.31005 9.42908 4.42005 9.59908 4.65005C9.76908 4.88005 9.79908 5.18005 9.67908 5.44005C9.41908 5.97005 9.18907 6.64005 8.99907 7.48005L8.01908 11.6701C7.12908 15.4501 8.15907 17.1001 11.9391 18.0001L13.6191 18.4001C14.1591 18.5301 14.6691 18.6101 15.1291 18.6501C15.4491 18.6801 15.7091 18.9 15.7991 19.21C15.8791 19.52 15.7591 19.8401 15.4991 20.0201C14.8391 20.4701 14.0091 20.8501 12.9591 21.1901L11.3791 21.71C10.2291 22.07 9.22907 22.25 8.32907 22.25ZM7.77908 6.22005L6.48907 6.64005C2.91907 7.79005 2.06907 9.47005 3.21907 13.0501L4.49907 17.0001C5.65907 20.5701 7.33907 21.4301 10.9091 20.2801L12.4891 19.7601C12.5491 19.7401 12.5991 19.7201 12.6591 19.7001L11.5991 19.4501C6.98908 18.3601 5.47907 15.9201 6.55907 11.3201L7.53907 7.13005C7.60907 6.81005 7.68908 6.50005 7.77908 6.22005Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M17.4933 10.51C17.4333 10.51 17.3733 10.5 17.3033 10.49L12.4533 9.26002C12.0533 9.16002 11.8133 8.75002 11.9133 8.35002C12.0133 7.95002 12.4233 7.71002 12.8233 7.81002L17.6733 9.04002C18.0733 9.14002 18.3133 9.55002 18.2133 9.95002C18.1333 10.28 17.8233 10.51 17.4933 10.51Z"
                                                        fill="#667085" />
                                                <path
                                                        d="M14.5611 13.89C14.5011 13.89 14.4411 13.88 14.3711 13.87L11.4611 13.13C11.0611 13.03 10.8211 12.62 10.9211 12.22C11.0211 11.82 11.4311 11.58 11.8311 11.68L14.7411 12.42C15.1411 12.52 15.3811 12.93 15.2811 13.33C15.2011 13.67 14.9011 13.89 14.5611 13.89Z"
                                                        fill="#667085" />
                                            </svg>
                                            {{ __('Post a Job') }}
                                        </a>
                                    </li>
                                @endif
                            @endif

                            @if(get_static_option('job_enable_disable') != 'disable')
                                <li class="profile-settings-menu-item">
                                    <a href="{{ route('client.job.all') }}" class="profile-settings-menu-item-link">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                    d="M16 22.7498H7.99998C3.37998 22.7498 2.51998 20.5998 2.29998 18.5098L1.54998 10.4998C1.43998 9.44977 1.40998 7.89977 2.44998 6.73977C3.34998 5.73977 4.83998 5.25977 6.99998 5.25977H17C19.17 5.25977 20.66 5.74977 21.55 6.73977C22.59 7.89977 22.56 9.44977 22.45 10.5098L21.7 18.4998C21.48 20.5998 20.62 22.7498 16 22.7498ZM6.99998 6.74977C5.30998 6.74977 4.14998 7.07977 3.55998 7.73977C3.06998 8.27977 2.90998 9.10977 3.03998 10.3498L3.78998 18.3598C3.95998 19.9398 4.38998 21.2498 7.99998 21.2498H16C19.6 21.2498 20.04 19.9398 20.21 18.3498L20.96 10.3598C21.09 9.10977 20.93 8.27977 20.44 7.73977C19.85 7.07977 18.69 6.74977 17 6.74977H6.99998Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M16 6.75C15.59 6.75 15.25 6.41 15.25 6V5.2C15.25 3.42 15.25 2.75 12.8 2.75H11.2C8.75 2.75 8.75 3.42 8.75 5.2V6C8.75 6.41 8.41 6.75 8 6.75C7.59 6.75 7.25 6.41 7.25 6V5.2C7.25 3.44 7.25 1.25 11.2 1.25H12.8C16.75 1.25 16.75 3.44 16.75 5.2V6C16.75 6.41 16.41 6.75 16 6.75Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M12 16.75C9.25 16.75 9.25 15.05 9.25 14.03V13C9.25 11.59 9.59 11.25 11 11.25H13C14.41 11.25 14.75 11.59 14.75 13V14C14.75 15.04 14.75 16.75 12 16.75ZM10.75 12.75C10.75 12.83 10.75 12.92 10.75 13V14.03C10.75 15.06 10.75 15.25 12 15.25C13.25 15.25 13.25 15.09 13.25 14.02V13C13.25 12.92 13.25 12.83 13.25 12.75C13.17 12.75 13.08 12.75 13 12.75H11C10.92 12.75 10.83 12.75 10.75 12.75Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M14 14.7702C13.63 14.7702 13.3 14.4902 13.26 14.1102C13.21 13.7002 13.5 13.3202 13.91 13.2702C16.55 12.9402 19.08 11.9402 21.21 10.3902C21.54 10.1402 22.01 10.2202 22.26 10.5602C22.5 10.8902 22.43 11.3602 22.09 11.6102C19.75 13.3102 16.99 14.4002 14.09 14.7702C14.06 14.7702 14.03 14.7702 14 14.7702Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M9.99999 14.7799C9.96999 14.7799 9.93999 14.7799 9.90999 14.7799C7.16999 14.4699 4.49999 13.4699 2.18999 11.8899C1.84999 11.6599 1.75999 11.1899 1.98999 10.8499C2.21999 10.5099 2.68999 10.4199 3.02999 10.6499C5.13999 12.0899 7.56999 12.9999 10.07 13.2899C10.48 13.3399 10.78 13.7099 10.73 14.1199C10.7 14.4999 10.38 14.7799 9.99999 14.7799Z"
                                                    fill="#667085" />
                                        </svg>
                                        {{ __('My Jobs') }}
                                    </a>
                                </li>
                            @endif
                            @if(get_static_option('subscription_enable_disable') != 'disable')
                                <li class="profile-settings-menu-item @if (request()->routeIs('client.subscriptions.all')) active @endif">
                                    <a href="{{ route('client.subscriptions.all') }}"
                                       class="profile-settings-menu-item-link">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                    d="M16.6999 19.7305H7.29994C6.55994 19.7305 5.80994 19.2005 5.55994 18.5105L1.41993 6.92047C0.909935 5.46047 1.27993 4.79047 1.67993 4.49047C2.07993 4.19047 2.82994 4.01047 4.08994 4.91047L7.98993 7.70047C8.10993 7.77047 8.21994 7.80047 8.29994 7.78047C8.38994 7.75047 8.45994 7.67047 8.50994 7.53047L10.2699 2.84047C10.7999 1.44047 11.5799 1.23047 11.9999 1.23047C12.4199 1.23047 13.1999 1.44047 13.7299 2.84047L15.4899 7.53047C15.5399 7.66047 15.6099 7.75047 15.6999 7.78047C15.7899 7.81047 15.8999 7.78047 16.0099 7.69047L19.6699 5.08047C21.0099 4.12047 21.7899 4.31047 22.2199 4.62047C22.6399 4.94047 23.0299 5.65047 22.4799 7.20047L18.4399 18.5105C18.1899 19.2005 17.4399 19.7305 16.6999 19.7305ZM2.67994 5.81047C2.69994 5.95047 2.73993 6.15047 2.83993 6.41047L6.97994 18.0005C7.01994 18.1005 7.19994 18.2305 7.29994 18.2305H16.6999C16.8099 18.2305 16.9899 18.1005 17.0199 18.0005L21.0599 6.70047C21.1999 6.32047 21.2399 6.06047 21.2499 5.91047C21.0999 5.96047 20.8699 6.07047 20.5399 6.31047L16.8799 8.92047C16.3799 9.27047 15.7899 9.38047 15.2599 9.22047C14.7299 9.06047 14.2999 8.64047 14.0799 8.07047L12.3199 3.38047C12.1899 3.03047 12.0699 2.86047 11.9999 2.78047C11.9299 2.86047 11.8099 3.03047 11.6799 3.37047L9.91994 8.06047C9.70994 8.63047 9.27993 9.05047 8.73993 9.21047C8.20993 9.37047 7.60994 9.26047 7.11994 8.91047L3.21994 6.12047C2.98994 5.96047 2.80994 5.86047 2.67994 5.81047Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M17.5 22.75H6.5C6.09 22.75 5.75 22.41 5.75 22C5.75 21.59 6.09 21.25 6.5 21.25H17.5C17.91 21.25 18.25 21.59 18.25 22C18.25 22.41 17.91 22.75 17.5 22.75Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M14.5 14.75H9.5C9.09 14.75 8.75 14.41 8.75 14C8.75 13.59 9.09 13.25 9.5 13.25H14.5C14.91 13.25 15.25 13.59 15.25 14C15.25 14.41 14.91 14.75 14.5 14.75Z"
                                                    fill="#667085" />
                                        </svg>
                                        {{ __('Subscriptions') }}
                                    </a>
                                </li>
                            @endif
                            <li class="profile-settings-menu-item">
                                <a href="{{ route('client.order.all') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M15 12.95H8C7.59 12.95 7.25 12.61 7.25 12.2C7.25 11.79 7.59 11.45 8 11.45H15C15.41 11.45 15.75 11.79 15.75 12.2C15.75 12.61 15.41 12.95 15 12.95Z"
                                                fill="#667085" />
                                        <path
                                                d="M12.38 16.95H8C7.59 16.95 7.25 16.61 7.25 16.2C7.25 15.79 7.59 15.45 8 15.45H12.38C12.79 15.45 13.13 15.79 13.13 16.2C13.13 16.61 12.79 16.95 12.38 16.95Z"
                                                fill="#667085" />
                                        <path
                                                d="M14 6.75H10C9.04 6.75 7.25 6.75 7.25 4C7.25 1.25 9.04 1.25 10 1.25H14C14.96 1.25 16.75 1.25 16.75 4C16.75 4.96 16.75 6.75 14 6.75ZM10 2.75C9.01 2.75 8.75 2.75 8.75 4C8.75 5.25 9.01 5.25 10 5.25H14C15.25 5.25 15.25 4.99 15.25 4C15.25 2.75 14.99 2.75 14 2.75H10Z"
                                                fill="#667085" />
                                        <path
                                                d="M15 22.7501H9C3.38 22.7501 2.25 20.1701 2.25 16.0001V10.0001C2.25 5.44005 3.9 3.49005 7.96 3.28005C8.36 3.26005 8.73 3.57005 8.75 3.99005C8.77 4.41005 8.45 4.75005 8.04 4.77005C5.2 4.93005 3.75 5.78005 3.75 10.0001V16.0001C3.75 19.7001 4.48 21.2501 9 21.2501H15C19.52 21.2501 20.25 19.7001 20.25 16.0001V10.0001C20.25 5.78005 18.8 4.93005 15.96 4.77005C15.55 4.75005 15.23 4.39005 15.25 3.98005C15.27 3.57005 15.63 3.25005 16.04 3.27005C20.1 3.49005 21.75 5.44005 21.75 9.99005V15.9901C21.75 20.1701 20.62 22.7501 15 22.7501Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('My Orders') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item">
                                <a href="{{ route('client.offers') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M12 22.75C11.37 22.75 10.78 22.51 10.34 22.06L8.82001 20.54C8.70001 20.42 8.38 20.29 8.22 20.29H6.06C4.76 20.29 3.70999 19.2399 3.70999 17.9399V15.78C3.70999 15.62 3.57999 15.3 3.45999 15.18L1.94 13.66C1.5 13.22 1.25 12.63 1.25 12C1.25 11.37 1.49 10.7799 1.94 10.3399L3.45999 8.81991C3.57999 8.69991 3.70999 8.37994 3.70999 8.21994V6.06002C3.70999 4.76002 4.76 3.70993 6.06 3.70993H8.22C8.38 3.70993 8.70001 3.57993 8.82001 3.45993L10.34 1.93991C11.22 1.05991 12.78 1.05991 13.66 1.93991L15.18 3.45993C15.3 3.57993 15.62 3.70993 15.78 3.70993H17.94C19.24 3.70993 20.29 4.76002 20.29 6.06002V8.21994C20.29 8.37994 20.42 8.69991 20.54 8.81991L22.06 10.3399C22.5 10.7799 22.75 11.37 22.75 12C22.75 12.63 22.51 13.22 22.06 13.66L20.54 15.18C20.42 15.3 20.29 15.62 20.29 15.78V17.9399C20.29 19.2399 19.24 20.29 17.94 20.29H15.78C15.62 20.29 15.3 20.42 15.18 20.54L13.66 22.06C13.22 22.51 12.63 22.75 12 22.75ZM4.51999 14.12C4.91999 14.52 5.20999 15.22 5.20999 15.78V17.9399C5.20999 18.4099 5.59 18.79 6.06 18.79H8.22C8.78 18.79 9.48 19.0799 9.88 19.4799L11.4 21C11.72 21.32 12.28 21.32 12.6 21L14.12 19.4799C14.52 19.0799 15.22 18.79 15.78 18.79H17.94C18.41 18.79 18.79 18.4099 18.79 17.9399V15.78C18.79 15.22 19.08 14.52 19.48 14.12L21 12.5999C21.16 12.4399 21.25 12.23 21.25 12C21.25 11.77 21.16 11.56 21 11.4L19.48 9.87997C19.08 9.47997 18.79 8.77994 18.79 8.21994V6.06002C18.79 5.59002 18.41 5.20993 17.94 5.20993H15.78C15.22 5.20993 14.52 4.91999 14.12 4.51999L12.6 2.99997C12.28 2.67997 11.72 2.67997 11.4 2.99997L9.88 4.51999C9.48 4.91999 8.78 5.20993 8.22 5.20993H6.06C5.59 5.20993 5.20999 5.59002 5.20999 6.06002V8.21994C5.20999 8.77994 4.91999 9.47997 4.51999 9.87997L3 11.4C2.84 11.56 2.75 11.77 2.75 12C2.75 12.23 2.84 12.4399 3 12.5999L4.51999 14.12Z"
                                                fill="#667085" />
                                        <path
                                                d="M15.0022 16C14.4422 16 13.9922 15.55 13.9922 15C13.9922 14.45 14.4422 14 14.9922 14C15.5422 14 15.9922 14.45 15.9922 15C15.9922 15.55 15.5522 16 15.0022 16Z"
                                                fill="#667085" />
                                        <path
                                                d="M9.01001 10C8.45001 10 8 9.55 8 9C8 8.45 8.45 8 9 8C9.55 8 10 8.45 10 9C10 9.55 9.56001 10 9.01001 10Z"
                                                fill="#667085" />
                                        <path
                                                d="M8.9975 15.75C8.8075 15.75 8.6175 15.68 8.4675 15.53C8.1775 15.24 8.1775 14.7599 8.4675 14.4699L14.4675 8.46994C14.7575 8.17994 15.2375 8.17994 15.5275 8.46994C15.8175 8.75994 15.8175 9.24 15.5275 9.53L9.5275 15.53C9.3775 15.68 9.1875 15.75 8.9975 15.75Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('My Offers') }}
                                </a>
                            </li>
                            @if(moduleExists('StripeConnect'))
                                <li class="profile-settings-menu-item @if (request()->routeIs('client.transaction.history')) active @endif">
                                    <a href="{{ route('client.transaction.history') }}" class="profile-settings-menu-item-link">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                    d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M6.19005 7.81044C5.95005 7.81044 5.73005 7.70044 5.58005 7.50044C5.41005 7.27044 5.39005 6.97044 5.52005 6.72044C5.69005 6.38044 5.93005 6.05044 6.24005 5.75044L9.49005 2.49043C11.15 0.84043 13.85 0.84043 15.51 2.49043L17.26 4.26045C18 4.99045 18.45 5.97045 18.5 7.01045C18.51 7.24045 18.42 7.46042 18.25 7.61042C18.08 7.76043 17.85 7.83045 17.63 7.79045C17.43 7.76045 17.22 7.75044 17 7.75044H7.00005C6.76005 7.75044 6.53005 7.77043 6.30005 7.80043C6.27005 7.81043 6.23005 7.81044 6.19005 7.81044ZM7.86005 6.25044H16.82C16.69 5.91044 16.48 5.60045 16.2 5.32045L14.44 3.54045C13.37 2.48045 11.62 2.48045 10.54 3.54045L7.86005 6.25044Z"
                                                    fill="#667085" />
                                            <path
                                                    d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                                    fill="#667085" />
                                        </svg>
                                        {{ __('Transactions History') }}
                                    </a>
                                </li>
                            @endif

                            <li class="profile-settings-menu-item @if (request()->routeIs('client.wallet.history')) active @endif">
                                <a href="{{ route('client.wallet.history') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M17 22.75H7C3.56 22.75 1.25 20.44 1.25 17V12C1.25 8.92 3.15 6.69001 6.1 6.32001C6.38 6.28001 6.69 6.25 7 6.25H17C17.24 6.25 17.55 6.26 17.87 6.31C20.82 6.65 22.75 8.89 22.75 12V17C22.75 20.44 20.44 22.75 17 22.75ZM7 7.75C6.76 7.75 6.53 7.76999 6.3 7.79999C4.1 8.07999 2.75 9.68 2.75 12V17C2.75 19.58 4.42 21.25 7 21.25H17C19.58 21.25 21.25 19.58 21.25 17V12C21.25 9.66 19.88 8.05001 17.66 7.79001C17.42 7.75001 17.21 7.75 17 7.75H7Z"
                                                fill="#667085" />
                                        <path
                                                d="M6.19005 7.81044C5.95005 7.81044 5.73005 7.70044 5.58005 7.50044C5.41005 7.27044 5.39005 6.97044 5.52005 6.72044C5.69005 6.38044 5.93005 6.05044 6.24005 5.75044L9.49005 2.49043C11.15 0.84043 13.85 0.84043 15.51 2.49043L17.26 4.26045C18 4.99045 18.45 5.97045 18.5 7.01045C18.51 7.24045 18.42 7.46042 18.25 7.61042C18.08 7.76043 17.85 7.83045 17.63 7.79045C17.43 7.76045 17.22 7.75044 17 7.75044H7.00005C6.76005 7.75044 6.53005 7.77043 6.30005 7.80043C6.27005 7.81043 6.23005 7.81044 6.19005 7.81044ZM7.86005 6.25044H16.82C16.69 5.91044 16.48 5.60045 16.2 5.32045L14.44 3.54045C13.37 2.48045 11.62 2.48045 10.54 3.54045L7.86005 6.25044Z"
                                                fill="#667085" />
                                        <path
                                                d="M22 17.25H19C17.48 17.25 16.25 16.02 16.25 14.5C16.25 12.98 17.48 11.75 19 11.75H22C22.41 11.75 22.75 12.09 22.75 12.5C22.75 12.91 22.41 13.25 22 13.25H19C18.31 13.25 17.75 13.81 17.75 14.5C17.75 15.19 18.31 15.75 19 15.75H22C22.41 15.75 22.75 16.09 22.75 16.5C22.75 16.91 22.41 17.25 22 17.25Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('Wallet') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.ticket')) active @endif">
                                <a href="{{ route('client.ticket') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <mask id="mask0_6522_7043" style="mask-type:alpha" maskUnits="userSpaceOnUse"
                                              x="0" y="0" width="24" height="24">
                                            <rect width="24" height="24" fill="#D9D9D9" />
                                        </mask>
                                        <g mask="url(#mask0_6522_7043)">
                                            <path
                                                    d="M12 22.5C11.8011 22.5 11.6103 22.421 11.4697 22.2803C11.329 22.1397 11.25 21.9489 11.25 21.75C11.25 21.5511 11.329 21.3603 11.4697 21.2197C11.6103 21.079 11.8011 21 12 21C14.3 21 16.16 20.3 16.9 19.5C16.1898 19.4692 15.5186 19.1666 15.0253 18.6547C14.5321 18.1428 14.2545 17.4609 14.25 16.75V13.75C14.2552 13.0223 14.5466 12.3258 15.0612 11.8112C15.5758 11.2966 16.2723 11.0052 17 11H18C18.4348 10.9971 18.8638 11.1001 19.25 11.3V10.75C19.25 9.79792 19.0625 8.85516 18.6981 7.97554C18.3338 7.09593 17.7997 6.2967 17.1265 5.62348C16.4533 4.95025 15.6541 4.41622 14.7745 4.05187C13.8948 3.68753 12.9521 3.5 12 3.5C11.0479 3.5 10.1052 3.68753 9.22554 4.05187C8.34593 4.41622 7.5467 4.95025 6.87348 5.62348C6.20025 6.2967 5.66622 7.09593 5.30187 7.97554C4.93753 8.85516 4.75 9.79792 4.75 10.75V11.3C5.13616 11.1001 5.56517 10.9971 6 11H7C7.72773 11.0052 8.42416 11.2966 8.93876 11.8112C9.45335 12.3258 9.74476 13.0223 9.75 13.75V16.75C9.74476 17.4777 9.45335 18.1742 8.93876 18.6888C8.42416 19.2034 7.72773 19.4948 7 19.5H6C5.27227 19.4948 4.57584 19.2034 4.06124 18.6888C3.54665 18.1742 3.25524 17.4777 3.25 16.75V10.75C3.25 8.42936 4.17187 6.20376 5.81282 4.56282C7.45376 2.92187 9.67936 2 12 2C14.3206 2 16.5462 2.92187 18.1872 4.56282C19.8281 6.20376 20.75 8.42936 20.75 10.75V16.75C20.7499 17.1109 20.6783 17.4681 20.5392 17.8011C20.4002 18.1341 20.1965 18.4362 19.94 18.69C19.5907 19.0543 19.1421 19.3081 18.65 19.42C18.11 21.22 15.43 22.5 12 22.5ZM17 12.5C16.6693 12.5026 16.3529 12.6352 16.119 12.869C15.8851 13.1029 15.7526 13.4193 15.75 13.75V16.75C15.7526 17.0807 15.8851 17.3971 16.119 17.631C16.3529 17.8649 16.6693 17.9974 17 18H18C18.3307 17.9974 18.6471 17.8649 18.881 17.631C19.1149 17.3971 19.2474 17.0807 19.25 16.75V13.75C19.2474 13.4193 19.1149 13.1029 18.881 12.869C18.6471 12.6352 18.3307 12.5026 18 12.5H17ZM4.75 13.75V16.75C4.75261 17.0807 4.88515 17.3971 5.11901 17.631C5.35286 17.8649 5.66929 17.9974 6 18H7C7.33071 17.9974 7.64714 17.8649 7.88099 17.631C8.11485 17.3971 8.24739 17.0807 8.25 16.75V13.75C8.24739 13.4193 8.11485 13.1029 7.88099 12.869C7.64714 12.6352 7.33071 12.5026 7 12.5H6C5.66929 12.5026 5.35286 12.6352 5.11901 12.869C4.88515 13.1029 4.75261 13.4193 4.75 13.75Z"
                                                    fill="#667085" />
                                        </g>
                                    </svg>
                                    {{ __('Support tickets') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.reports.all')) active @endif">
                                <a href="{{ route('client.reports.all') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5.1499 22.75C4.7399 22.75 4.3999 22.41 4.3999 22V2C4.3999 1.59 4.7399 1.25 5.1499 1.25C5.5599 1.25 5.8999 1.59 5.8999 2V22C5.8999 22.41 5.5599 22.75 5.1499 22.75Z" fill="#667085"/>
                                        <path d="M16.3735 11.5764L16.3619 11.5649L16.3497 11.5542C15.9718 11.2226 15.7245 10.7058 15.6995 10.1099C15.6753 9.49393 15.9189 8.87812 16.3735 8.42355L17.5735 7.22355C17.97 6.827 18.2498 6.44874 18.4167 6.11198C18.5 5.94372 18.5611 5.774 18.589 5.60902C18.6161 5.44872 18.6176 5.25772 18.5404 5.07518C18.3985 4.73986 18.0492 4.54794 17.728 4.43899C17.3744 4.31909 16.912 4.25 16.3499 4.25H5.1499C5.01038 4.25 4.8999 4.13821 4.8999 4C4.8999 3.86614 5.01604 3.75 5.1499 3.75H16.3499C17.3763 3.75 18.002 3.96301 18.3821 4.19787C18.756 4.42886 18.9266 4.7019 19.0083 4.89232C19.0846 5.08122 19.1577 5.39331 19.0559 5.82199C18.9524 6.25812 18.6582 6.85457 17.9263 7.58645L16.7263 8.78645C16.3802 9.13265 16.1861 9.61526 16.2001 10.1043L16.2002 10.1067C16.2142 10.5274 16.3831 10.9251 16.6951 11.2123L17.9263 12.4336C17.9266 12.4338 17.9268 12.434 17.9271 12.4343C18.6421 13.1495 18.9287 13.7372 19.0291 14.1703C19.1274 14.5949 19.056 14.9103 18.9783 15.1075C18.8962 15.294 18.7223 15.5675 18.3503 15.7995C17.9716 16.0357 17.3535 16.25 16.3499 16.25H5.1499C5.01604 16.25 4.8999 16.1339 4.8999 16C4.8999 15.8661 5.01604 15.75 5.1499 15.75H16.3499C16.935 15.75 17.3984 15.6727 17.7469 15.5418C18.0738 15.4191 18.3867 15.2142 18.5141 14.8957C18.6381 14.5857 18.5664 14.2275 18.4195 13.9068C18.2647 13.5688 17.9904 13.1882 17.5723 12.7753C17.5719 12.7749 17.5715 12.7745 17.5712 12.7742L16.3735 11.5764Z" stroke="#667085"/>
                                    </svg>
                                    {{ __('All Reports') }}
                                </a>
                            </li>

                            <li class="profile-settings-menu-item">
                                <a href="{{ route('client.live.chat') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <mask id="mask0_6522_7114" style="mask-type:alpha" maskUnits="userSpaceOnUse"
                                              x="0" y="0" width="24" height="24">
                                            <rect width="24" height="24" fill="#D9D9D9" />
                                        </mask>
                                        <g mask="url(#mask0_6522_7114)">
                                            <path
                                                    d="M2.98121 20.7488C2.87552 20.749 2.771 20.7268 2.67449 20.6837C2.57798 20.6406 2.49167 20.5776 2.42121 20.4988C2.33208 20.4003 2.27112 20.2796 2.24473 20.1494C2.21834 20.0192 2.22748 19.8843 2.27121 19.7588L3.45121 16.1988C2.35425 14.3826 2.00494 12.2116 2.47686 10.143C2.94879 8.07433 4.2051 6.26958 5.98121 5.10883C7.87969 3.80773 10.148 3.15537 12.4476 3.24909C14.7472 3.3428 16.9549 4.17757 18.7412 5.62883C19.5817 6.30768 20.2784 7.14724 20.7907 8.09846C21.303 9.04967 21.6206 10.0935 21.7249 11.1688C21.8291 12.2442 21.718 13.3295 21.3981 14.3614C21.0781 15.3933 20.5556 16.3511 19.8612 17.1788C18.3665 18.8724 16.3667 20.0404 14.1573 20.5104C11.9479 20.9803 9.64586 20.7274 7.59121 19.7888L3.14121 20.7288L2.98121 20.7488ZM7.68121 18.2488C7.79567 18.2516 7.9082 18.2789 8.01121 18.3288C9.77535 19.1905 11.7729 19.4517 13.6992 19.0726C15.6256 18.6934 17.3752 17.6948 18.6812 16.2288C19.2483 15.5503 19.6743 14.7654 19.9343 13.9202C20.1943 13.075 20.2832 12.1864 20.1957 11.3064C20.1081 10.4265 19.846 9.57279 19.4245 8.79537C19.0031 8.01795 18.4308 7.3324 17.7412 6.77883C16.2119 5.53354 14.3201 4.81756 12.3495 4.73823C10.3789 4.6589 8.43568 5.2205 6.81121 6.33883C6.06825 6.82298 5.42879 7.4498 4.92992 8.18295C4.43104 8.91611 4.08267 9.741 3.905 10.6098C3.72733 11.4786 3.7239 12.374 3.89491 13.2442C4.06592 14.1143 4.40796 14.9419 4.90121 15.6788C4.96467 15.7751 5.0057 15.8844 5.02127 15.9986C5.03685 16.1128 5.02658 16.2291 4.99121 16.3388L4.11121 18.9988L7.52121 18.2788L7.68121 18.2488Z"
                                                    fill="#667085" />
                                        </g>
                                    </svg>
                                    {{ __('Live Chat') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client._2fa')) active @endif">
                                <a href="{{ route('client._2fa') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M11.9984 22.76C10.9084 22.76 9.82844 22.44 8.97844 21.81L4.67844 18.6C3.53844 17.75 2.64844 15.97 2.64844 14.56V7.12C2.64844 5.58 3.77844 3.94 5.22844 3.4L10.2184 1.53C11.2084 1.16 12.7684 1.16 13.7584 1.53L18.7484 3.4C20.1984 3.94 21.3284 5.58 21.3284 7.12V14.55C21.3284 15.97 20.4384 17.74 19.2984 18.59L14.9984 21.8C14.1684 22.44 13.0884 22.76 11.9984 22.76ZM10.7484 2.94L5.75844 4.81C4.90844 5.13 4.15844 6.21 4.15844 7.13V14.56C4.15844 15.51 4.82844 16.84 5.57844 17.4L9.87844 20.61C11.0284 21.47 12.9684 21.47 14.1284 20.61L18.4284 17.4C19.1884 16.83 19.8484 15.51 19.8484 14.56V7.12C19.8484 6.21 19.0984 5.13 18.2484 4.8L13.2584 2.93C12.5784 2.69 11.4184 2.69 10.7484 2.94Z"
                                                fill="#667085" />
                                        <path
                                                d="M10.6622 14.23C10.4722 14.23 10.2822 14.16 10.1322 14.01L8.52219 12.4C8.23219 12.11 8.23219 11.63 8.52219 11.34C8.81219 11.05 9.29219 11.05 9.58219 11.34L10.6622 12.42L14.4322 8.65C14.7222 8.36 15.2022 8.36 15.4922 8.65C15.7822 8.94 15.7822 9.42 15.4922 9.71L11.1922 14.01C11.0422 14.16 10.8522 14.23 10.6622 14.23Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('2 Factor Authentication') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.password')) active @endif">
                                <a href="{{ route('client.password') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M18 10.75C17.59 10.75 17.25 10.41 17.25 10V8C17.25 4.85 16.36 2.75 12 2.75C7.64 2.75 6.75 4.85 6.75 8V10C6.75 10.41 6.41 10.75 6 10.75C5.59 10.75 5.25 10.41 5.25 10V8C5.25 5.1 5.95 1.25 12 1.25C18.05 1.25 18.75 5.1 18.75 8V10C18.75 10.41 18.41 10.75 18 10.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M12 19.25C10.21 19.25 8.75 17.79 8.75 16C8.75 14.21 10.21 12.75 12 12.75C13.79 12.75 15.25 14.21 15.25 16C15.25 17.79 13.79 19.25 12 19.25ZM12 14.25C11.04 14.25 10.25 15.04 10.25 16C10.25 16.96 11.04 17.75 12 17.75C12.96 17.75 13.75 16.96 13.75 16C13.75 15.04 12.96 14.25 12 14.25Z"
                                                fill="#667085" />
                                        <path
                                                d="M17 22.75H7C2.59 22.75 1.25 21.41 1.25 17V15C1.25 10.59 2.59 9.25 7 9.25H17C21.41 9.25 22.75 10.59 22.75 15V17C22.75 21.41 21.41 22.75 17 22.75ZM7 10.75C3.42 10.75 2.75 11.43 2.75 15V17C2.75 20.57 3.42 21.25 7 21.25H17C20.58 21.25 21.25 20.57 21.25 17V15C21.25 11.43 20.58 10.75 17 10.75H7Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('Change Password') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.profile')) active @endif">
                                <a href="{{ route('client.profile') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M12 15.75C9.93 15.75 8.25 14.07 8.25 12C8.25 9.93 9.93 8.25 12 8.25C14.07 8.25 15.75 9.93 15.75 12C15.75 14.07 14.07 15.75 12 15.75ZM12 9.75C10.76 9.75 9.75 10.76 9.75 12C9.75 13.24 10.76 14.25 12 14.25C13.24 14.25 14.25 13.24 14.25 12C14.25 10.76 13.24 9.75 12 9.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M15.21 22.1903C15 22.1903 14.79 22.1603 14.58 22.1103C13.96 21.9403 13.44 21.5503 13.11 21.0003L12.99 20.8003C12.4 19.7803 11.59 19.7803 11 20.8003L10.89 20.9903C10.56 21.5503 10.04 21.9503 9.42 22.1103C8.79 22.2803 8.14 22.1903 7.59 21.8603L5.87 20.8703C5.26 20.5203 4.82 19.9503 4.63 19.2603C4.45 18.5703 4.54 17.8603 4.89 17.2503C5.18 16.7403 5.26 16.2803 5.09 15.9903C4.92 15.7003 4.49 15.5303 3.9 15.5303C2.44 15.5303 1.25 14.3403 1.25 12.8803V11.1203C1.25 9.66029 2.44 8.47029 3.9 8.47029C4.49 8.47029 4.92 8.30029 5.09 8.01029C5.26 7.72029 5.19 7.26029 4.89 6.75029C4.54 6.14029 4.45 5.42029 4.63 4.74029C4.81 4.05029 5.25 3.48029 5.87 3.13029L7.6 2.14029C8.73 1.47029 10.22 1.86029 10.9 3.01029L11.02 3.21029C11.61 4.23029 12.42 4.23029 13.01 3.21029L13.12 3.02029C13.8 1.86029 15.29 1.47029 16.43 2.15029L18.15 3.14029C18.76 3.49029 19.2 4.06029 19.39 4.75029C19.57 5.44029 19.48 6.15029 19.13 6.76029C18.84 7.27029 18.76 7.73029 18.93 8.02029C19.1 8.31029 19.53 8.48029 20.12 8.48029C21.58 8.48029 22.77 9.67029 22.77 11.1303V12.8903C22.77 14.3503 21.58 15.5403 20.12 15.5403C19.53 15.5403 19.1 15.7103 18.93 16.0003C18.76 16.2903 18.83 16.7503 19.13 17.2603C19.48 17.8703 19.58 18.5903 19.39 19.2703C19.21 19.9603 18.77 20.5303 18.15 20.8803L16.42 21.8703C16.04 22.0803 15.63 22.1903 15.21 22.1903ZM12 18.4903C12.89 18.4903 13.72 19.0503 14.29 20.0403L14.4 20.2303C14.52 20.4403 14.72 20.5903 14.96 20.6503C15.2 20.7103 15.44 20.6803 15.64 20.5603L17.37 19.5603C17.63 19.4103 17.83 19.1603 17.91 18.8603C17.99 18.5603 17.95 18.2503 17.8 17.9903C17.23 17.0103 17.16 16.0003 17.6 15.2303C18.04 14.4603 18.95 14.0203 20.09 14.0203C20.73 14.0203 21.24 13.5103 21.24 12.8703V11.1103C21.24 10.4803 20.73 9.96029 20.09 9.96029C18.95 9.96029 18.04 9.52029 17.6 8.75029C17.16 7.98029 17.23 6.97029 17.8 5.99029C17.95 5.73029 17.99 5.42029 17.91 5.12029C17.83 4.82029 17.64 4.58029 17.38 4.42029L15.65 3.43029C15.22 3.17029 14.65 3.32029 14.39 3.76029L14.28 3.95029C13.71 4.94029 12.88 5.50029 11.99 5.50029C11.1 5.50029 10.27 4.94029 9.7 3.95029L9.59 3.75029C9.34 3.33029 8.78 3.18029 8.35 3.43029L6.62 4.43029C6.36 4.58029 6.16 4.83029 6.08 5.13029C6 5.43029 6.04 5.74029 6.19 6.00029C6.76 6.98029 6.83 7.99029 6.39 8.76029C5.95 9.53029 5.04 9.97029 3.9 9.97029C3.26 9.97029 2.75 10.4803 2.75 11.1203V12.8803C2.75 13.5103 3.26 14.0303 3.9 14.0303C5.04 14.0303 5.95 14.4703 6.39 15.2403C6.83 16.0103 6.76 17.0203 6.19 18.0003C6.04 18.2603 6 18.5703 6.08 18.8703C6.16 19.1703 6.35 19.4103 6.61 19.5703L8.34 20.5603C8.55 20.6903 8.8 20.7203 9.03 20.6603C9.27 20.6003 9.47 20.4403 9.6 20.2303L9.71 20.0403C10.28 19.0603 11.11 18.4903 12 18.4903Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('Profile Settings') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item @if (request()->routeIs('client.identity.verification')) active @endif">
                                <a href="{{ route('client.identity.verification') }}"
                                   class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M17 21.75H7C2.59 21.75 1.25 20.41 1.25 16V8C1.25 3.59 2.59 2.25 7 2.25H17C21.41 2.25 22.75 3.59 22.75 8V16C22.75 20.41 21.41 21.75 17 21.75ZM7 3.75C3.42 3.75 2.75 4.43 2.75 8V16C2.75 19.57 3.42 20.25 7 20.25H17C20.58 20.25 21.25 19.57 21.25 16V8C21.25 4.43 20.58 3.75 17 3.75H7Z"
                                                fill="#667085" />
                                        <path
                                                d="M19 8.75H14C13.59 8.75 13.25 8.41 13.25 8C13.25 7.59 13.59 7.25 14 7.25H19C19.41 7.25 19.75 7.59 19.75 8C19.75 8.41 19.41 8.75 19 8.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M19 12.75H15C14.59 12.75 14.25 12.41 14.25 12C14.25 11.59 14.59 11.25 15 11.25H19C19.41 11.25 19.75 11.59 19.75 12C19.75 12.41 19.41 12.75 19 12.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M19 16.75H17C16.59 16.75 16.25 16.41 16.25 16C16.25 15.59 16.59 15.25 17 15.25H19C19.41 15.25 19.75 15.59 19.75 16C19.75 16.41 19.41 16.75 19 16.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M8.4975 12.04C7.0875 12.04 5.9375 10.89 5.9375 9.47998C5.9375 8.06998 7.0875 6.91998 8.4975 6.91998C9.9075 6.91998 11.0575 8.06998 11.0575 9.47998C11.0575 10.89 9.9075 12.04 8.4975 12.04ZM8.4975 8.41998C7.9175 8.41998 7.4375 8.89998 7.4375 9.47998C7.4375 10.06 7.9175 10.54 8.4975 10.54C9.0775 10.54 9.5575 10.06 9.5575 9.47998C9.5575 8.89998 9.0775 8.41998 8.4975 8.41998Z"
                                                fill="#667085" />
                                        <path
                                                d="M11.998 17.08C11.618 17.08 11.288 16.79 11.248 16.4C11.138 15.32 10.268 14.45 9.17795 14.35C8.71795 14.31 8.25795 14.31 7.79795 14.35C6.70795 14.45 5.83795 15.31 5.72795 16.4C5.68795 16.81 5.31795 17.12 4.90795 17.07C4.49795 17.03 4.19795 16.66 4.23795 16.25C4.41795 14.45 5.84795 13.02 7.65795 12.86C8.20795 12.81 8.76795 12.81 9.31795 12.86C11.118 13.03 12.558 14.46 12.738 16.25C12.778 16.66 12.478 17.03 12.068 17.07C12.048 17.08 12.018 17.08 11.998 17.08Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('Identity Verification') }}
                                </a>
                            </li>
                            <li class="profile-settings-menu-item">
                                <a href="{{ route('client.logout') }}" class="profile-settings-menu-item-link">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path
                                                d="M15.24 22.2705H15.11C10.67 22.2705 8.53002 20.5205 8.16002 16.6005C8.12002 16.1905 8.42002 15.8205 8.84002 15.7805C9.24002 15.7405 9.62002 16.0505 9.66002 16.4605C9.95002 19.6005 11.43 20.7705 15.12 20.7705H15.25C19.32 20.7705 20.76 19.3305 20.76 15.2605V8.74047C20.76 4.67047 19.32 3.23047 15.25 3.23047H15.12C11.41 3.23047 9.93002 4.42047 9.66002 7.62047C9.61002 8.03047 9.26002 8.34047 8.84002 8.30047C8.42002 8.27047 8.12001 7.90047 8.15001 7.49047C8.49001 3.51047 10.64 1.73047 15.11 1.73047H15.24C20.15 1.73047 22.25 3.83047 22.25 8.74047V15.2605C22.25 20.1705 20.15 22.2705 15.24 22.2705Z"
                                                fill="#667085" />
                                        <path
                                                d="M15.0001 12.75H3.62012C3.21012 12.75 2.87012 12.41 2.87012 12C2.87012 11.59 3.21012 11.25 3.62012 11.25H15.0001C15.4101 11.25 15.7501 11.59 15.7501 12C15.7501 12.41 15.4101 12.75 15.0001 12.75Z"
                                                fill="#667085" />
                                        <path
                                                d="M5.84994 16.0998C5.65994 16.0998 5.46994 16.0298 5.31994 15.8798L1.96994 12.5298C1.67994 12.2398 1.67994 11.7598 1.96994 11.4698L5.31994 8.11984C5.60994 7.82984 6.08994 7.82984 6.37994 8.11984C6.66994 8.40984 6.66994 8.88984 6.37994 9.17984L3.55994 11.9998L6.37994 14.8198C6.66994 15.1098 6.66994 15.5898 6.37994 15.8798C6.23994 16.0298 6.03994 16.0998 5.84994 16.0998Z"
                                                fill="#667085" />
                                    </svg>
                                    {{ __('Log Out') }}
                                </a>
                            </li>
                        </ul>
                    @endif
                @endif
            @endif
        </div>
    </div>
</div>
