<script>
    (function ($) {
        "use strict";
        $(document).ready(function () {
            $('.country_select2').select2();
            $('.category_select2').select2();
            $('.subcategory_select2').select2();
            $('.state_select2').select2();
            $('.skills_select2').select2();

            // change category and get subcategory
            $('#subcategory_info').hide();

            $(document).on('change','#category', function() {
                let category = $(this).val();
                let jsonOldCategory = @json(old('subcategory', []));

                $('#subcategory_info').show();
                $.ajax({
                    method: 'post',
                    url: "{{ route('au.subcategory.all') }}",
                    data: {
                        category: category,
                        old_sub_categories: '{{ json_encode(old('subcategory') ?? []) }}'
                    },
                    success: function(res) {
                        if (res.status == 'success') {
                            let all_options = "<option value=''>{{__('Select Sub Category')}}</option>";
                            let all_subcategories = res.subcategories;

                            $.each(all_subcategories, function(index, value) {
                                all_options += `<option ${jsonOldCategory?.includes(value?.id?.toString() ?? 0) ? 'selected=\'selected\'' : ''} value='${value.id}'>${value.sub_category ?? ''}</option>`;
                            });


                            $("#subcategory").val(null); // Clear the value BEFORE updating options**
                            $(".get_subcategory").html(all_options);   // Update the options
                            $("#subcategory").trigger('change'); // Trigger change AFTER updating HTML to refresh Select2

                            $("#subcategory_info").html('');
                            if(all_subcategories.length <= 0){
                                $("#subcategory_info").html('<span class="text-danger"> {{ __('No sub categories found for selected category!') }} <span>');
                            }
                        }
                    }
                })
            })

            // change country and get state
            $('#state_info').hide();
            $(document).on('change','#country', function() {
                let country = $(this).val();
                let jsonOldState = @json(old('state', []));

                if(country) {
                    $('#state_info').show();
                    $.ajax({
                        method: 'post',
                        url: "{{ route('au.state.all') }}",
                        data: {
                            country: country,
                            old_states: '{{ json_encode(old('state') ?? []) }}'
                        },
                        success: function(res) {
                            if (res.status == 'success') {
                                let all_options = "<option value=''>{{__('Select State')}}</option>";
                                let all_states = res.states;

                                $.each(all_states, function(index, value) {
                                    all_options += `<option ${jsonOldState?.includes(value?.id?.toString() ?? 0) ? 'selected=\'selected\'' : ''} value='${value.id}'>${value.state ?? ''}</option>`;
                                });



                                $("#state").val(null); //Clear the value BEFORE updating options**
                                $(".get_state").html(all_options); // Update the options
                                $("#state").trigger('change'); // Trigger change AFTER updating HTML to refresh Select2


                                $("#state").next('.select2-container').find('.select2-selection__rendered ').html('');
                                $(".get_state").html(all_options);

                                $("#state_info").html('');
                                if(all_states.length <= 0){
                                    $("#state_info").html('<span class="text-danger"> {{ __('No states found for selected country!') }} <span>');
                                }
                            }
                        }
                    });
                } else {
                    // Reset state when no country is selected
                    $('#state_info').hide();
                    $("#state").next('.select2-container').find('.select2-selection__rendered ').html('');
                    $(".get_state").html("<option value=''>{{__('Select State')}}</option>");
                }
            });

            //star rating filter
            $(document).on('click', '.active-list .list', function() {
                $(this).siblings().removeClass('active');
                $(this).addClass('active');
            });

            $(document).on('keydown', '#job_search_string', function (e) {
                if (e.key === "Enter" || e.which === 13) {
                    e.preventDefault(); 
                    $('#job_search_by_text').click();
                }
            });

            $(document).on('click','#job_search_by_text',function(){
                if ($('#job_search_string').val() == '') {
                    return false;
                }else{
                    let category = $('#category').val();
                    let subcategory = $('#subcategory').val();
                    let country = $('#country').val();
                    let state = $('#state').val();
                    let skills = $('#skills').val();
                    let type = $('#type').val();
                    let level = $('#level').val();
                    let min_price = $('#min_price').val();
                    let max_price = $('#max_price').val();
                    let duration = $('#duration').val();
                    let job_search_string = $('#job_search_string').val();
                    $.ajax({
                        url:"{{ route('jobs.filter')}}",
                        method:'GET',
                        data:{category:category,subcategory:subcategory,country:country,state:state, skills:skills, type:type,level:level,min_price:min_price,max_price:max_price,duration:duration,job_search_string:job_search_string},
                        success:function(res){
                            if(res.status=='nothing'){
                                $('.search_job_result').html(
                                    `<div class="congratulation-area section-bg-2 pat-100 pab-100">
                                    <div class="container">
                                        <div class="congratulation-wrapper">
                                            <div class="congratulation-contents center-text">
                                                <div class="congratulation-contents-icon bg-danger wow  zoomIn animated" data-wow-delay=".5s" style="visibility: visible; animation-delay: 0.5s; animation-name: zoomIn;">
                                                    <i class="fas fa-times"></i>
                                                </div>
                                                <h4 class="congratulation-contents-title"> {{ __('OPPS!') }} </h4>
                                                <p class="congratulation-contents-para">{{ __('Nothing') }} <strong>{{ __('Found') }}</strong> </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>`);
                            }else{
                                $('.search_job_result').html(res);
                            }
                        }
                    });
                }
            })

            //job filter
            $(document).on('change', '#subcategory, #state, #skills, #type , #level , #duration', function() {
                let category = $('#category').val();
                let subcategory = $('#subcategory').val();
                let country = $('#country').val();
                let state = $('#state').val();
                let type = $('#type').val();
                let skills = $('#skills').val();
                let level = $('#level').val();
                let min_price = $('#min_price').val();
                let max_price = $('#max_price').val();
                let duration = $('#duration').val();
                let job_search_string = $('#job_search_string').val();
                console.log(category);
                $.ajax({
                    url:"{{ route('jobs.filter')}}",
                    method:'GET',
                    data:{category:category,subcategory:subcategory,country:country,state:state, skills:skills, type:type,level:level,min_price:min_price,max_price:max_price,duration:duration,job_search_string:job_search_string},
                    success:function(res){
                        if(res.status=='nothing'){
                            $('.search_job_result').html(
                                `<div class="congratulation-area section-bg-2 pat-100 pab-100">
                                    <div class="container">
                                        <div class="congratulation-wrapper">
                                            <div class="congratulation-contents center-text">
                                                <div class="congratulation-contents-icon bg-danger wow  zoomIn animated" data-wow-delay=".5s" style="visibility: visible; animation-delay: 0.5s; animation-name: zoomIn;">
                                                    <i class="fas fa-times"></i>
                                                </div>
                                                <h4 class="congratulation-contents-title"> {{ __('OPPS!') }} </h4>
                                                <p class="congratulation-contents-para">{{ __('Nothing') }} <strong>{{ __('Found') }}</strong> </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>`);
                        }else{
                            $('.search_job_result').html(res);
                        }
                    }
                });
            });

            $(document).on('click', '#set_price_range', function() {
                let category = $('#category').val();
                let subcategory = $('#subcategory').val();
                let country = $('#country').val();
                let state = $('#state').val();
                let type = $('#type').val();
                let skills = $('#skills').val();
                let level = $('#level').val();
                let min_price = parseFloat($('#min_price').val());
                let max_price = parseFloat($('#max_price').val());
                let duration = $('#duration').val();
                let job_search_string = $('#job_search_string').val();

                // check empty
                if (isNaN(min_price) || isNaN(max_price)) {
                    toastr_warning_js("{{ __('Both fields are required!') }}");
                    return false;
                }

                // check negative
                if (min_price < 0 || max_price < 0) {
                    toastr_warning_js("{{ __('Price cannot be negative!') }}");
                    return false;
                }

                // check range
                if (min_price > max_price) {
                    toastr_warning_js("{{ __('Minimum price cannot be greater than maximum price!') }}");
                    return false;
                }

                $.ajax({
                    url:"{{ route('jobs.filter')}}",
                    method:'GET',
                    data:{category:category,subcategory:subcategory,country:country,state:state, skills:skills, type:type,level:level,min_price:min_price,max_price:max_price,duration:duration,job_search_string:job_search_string},
                    success:function(res){
                        if(res.status=='nothing'){
                            $('.search_job_result').html(
                                `<div class="congratulation-area section-bg-2 pat-100 pab-100">
                                    <div class="container">
                                        <div class="congratulation-wrapper">
                                            <div class="congratulation-contents center-text">
                                                <div class="congratulation-contents-icon bg-danger wow  zoomIn animated" data-wow-delay=".5s" style="visibility: visible; animation-delay: 0.5s; animation-name: zoomIn;">
                                                    <i class="fas fa-times"></i>
                                                </div>
                                                <h4 class="congratulation-contents-title"> {{ __('OPPS!') }} </h4>
                                                <p class="congratulation-contents-para">{{ __('Nothing') }} <strong>{{ __('Found') }}</strong> </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>`);
                        }else{
                            $('.search_job_result').html(res);
                        }
                    }
                });
            });

            // pagination
            $(document).on('click', '.pagination a', function(e){
                e.preventDefault();
                let page = $(this).attr('href').split('page=')[1];
                let category = $('#category').val();
                let subcategory = $('#subcategory').val();
                let country = $('#country').val();
                let state = $('#state').val();
                let type = $('#type').val();
                let skills = $('#skills').val();
                let level = $('#level').val();
                let min_price = $('#min_price').val();
                let max_price = $('#max_price').val();
                let duration = $('#duration').val();
                let job_search_string = $('#job_search_string').val();

                jobs(page,category,subcategory,country, state, skills, type,level,min_price,max_price,duration,job_search_string);
            });
            function jobs(page,category,subcategory,country,state, skills, type,level,min_price,max_price,duration,job_search_string){
                $.ajax({
                    url:"{{ route('jobs.pagination').'?page='}}" + page,
                    method:'GET',
                    data:{country:country,state:state, category:category,subcategory:subcategory, skills:skills, type:type,level:level,min_price:min_price,max_price:max_price,duration:duration,job_search_string:job_search_string},
                    success:function(res){
                        if(res.status=='nothing'){
                            $('.search_job_result').html('<h3 class="text-center text-danger">'+"{{ __('Nothing Found') }}"+'</h3>');
                        }else{
                            $('.search_job_result').html(res);
                            $('html, body').animate({ scrollTop: 0 }, 'smooth');
                        }
                    }

                });
            }

            // filter reset
            $(document).on('click', '#job_filter_reset', function(e){
                e.preventDefault();
                $('#country').val('').trigger('change');
                $('#state').val('').trigger('change');
                $('#category').val('').trigger('change');
                $('#subcategory').val('').trigger('change');
                $('#skills').val(null).trigger('change');
                $('#type').val('');
                $('#level').val('');
                $('#min_price').val('');
                $('#max_price').val('');
                $('#duration').val('');
                $('#job_search_string').val('');

                $.ajax({
                    url:"{{ route('jobs.filter.reset')}}",
                    method:'GET',
                    success:function(res){
                        if(res.status=='nothing'){
                            $('.search_job_result').html('<h3 class="text-center text-danger">'+"{{ __('Nothing Found') }}"+'</h3>');
                        }else{
                            $('.search_job_result').html(res);
                        }
                    }

                });
            });
        });
    }(jQuery));
</script>
