<script>
    (function ($) {
        "use strict";
        $(document).ready(function () {

            //prevent multiple submit
            $('#job_proposal_form').on('submit', function () {
                $('.send_job_proposal').attr('disabled', 'true');
            });

            // **MODIFIED: proposal validate with restricted word check**
            $(document).on('click', '.send_job_proposal', function(e){
                let amount = $('#job_proposal_form #amount').val();
                let duration = $('#job_proposal_form #duration').val();
                let revision = $('#job_proposal_form #revision').val();
                let cover_letter = $('#job_proposal_form #cover_letter').val();

                if(amount == '' || duration == '' || cover_letter == '' || revision == ''){
                    e.preventDefault();
                    toastr_warning_js("{{ __('Except attachment all fields required!') }}")
                    return false;
                }else if(amount<1){
                    e.preventDefault();
                    toastr_warning_js("{{ __('Amount must be greater than 1.') }}")
                    return false;
                }else if(cover_letter.length<10){
                    e.preventDefault();
                    toastr_warning_js("{{ __('Cover letter must be greater than 10 characters.') }}")
                    return false;
                }

                // **ADDED: Check for restricted words in cover letter**
                @if(moduleExists('SecurityManage'))
                    let module_exits = "<?php echo moduleExists('SecurityManage') ?? '' ?>";
                    if (module_exits) {
                        let words = JSON.parse('<?php echo json_encode(\Modules\SecurityManage\Entities\Word::select('word')->where("status", "active")->pluck("word")->toArray()); ?>');

                        let combinedText = cover_letter.toLowerCase();

                        function checkAnyWordExists(words, text) {
                            return words.some(word => text.includes(word.toLowerCase()));
                        }
                        let anyWordExists = checkAnyWordExists(words, combinedText);

                        function getAllMatchedWords(words, text) {
                            return words.filter(word => text.includes(word.toLowerCase()));
                        }

                        // Get all matching words
                        let matchedWords = getAllMatchedWords(words, combinedText);

                        if (anyWordExists) {
                            e.preventDefault();
                            toastr_warning_js('{{ __("You cannot use restricted words: ") }}' + matchedWords.join(', '));
                            return false;
                        }
                    }
                @endif
                // END OF ADDITION
                else{
                    $('#send_proposal_load_spinner').html('<i class="fas fa-spinner fa-pulse"></i>')

                }

            });

            //tooltip
            $("body").tooltip({ selector: '[data-toggle=tooltip]' });

            // login
            $(document).on('click', '.login_to_continue_order', function(e){
                e.preventDefault();
                let username = $('#username').val();
                let password = $('#password').val();
                let erContainer = $(".error-message");
                erContainer.html('');
                $.ajax({
                    url:"{{ route('order.user.login')}}",
                    data:{username:username,password:password},
                    method:'POST',
                    error:function(res){
                        let errors = res.responseJSON;
                        erContainer.html('<div class="alert alert-danger"></div>');
                        $.each(errors.errors, function(index,value){
                            erContainer.find('.alert.alert-danger').append('<p>'+value+'</p>');
                        });
                    },
                    success: function(res){
                        if(res.status=='success'){
                            window.location.reload();
                        }
                        if(res.status == 'failed'){
                            erContainer.html('<div class="alert alert-danger">'+res.msg+'</div>');
                        }
                    }


                });
            });

        });
    }(jQuery));
</script>
