<div class="compare-profile-and-identity">
    <div class="row g-4 gy-5">
        <div class="col-lg-6">
            <div class="user-profile userProfileDetails">
                <div class="userProfileDetails__header">
                    <h5 class="userProfileDetails__title">{{__('User Profile Info')}}</h5>
                    <input type="hidden" id="user_id_for_verified_status" value="{{ $user_details->id }}">
                </div>
                <div class="userDetails__wrapper userProfile__details mt-3">
                    <div class="userProfile__details__thumb mb-3">
                        @if(!empty($user_details->image))
                            @if(cloudStorageExist() && in_array(Storage::getDefaultDriver(), ['s3', 'cloudFlareR2', 'wasabi']))
                                <img src="{{ render_frontend_cloud_image_if_module_exists( 'profile/'. $user_details->image, load_from: $user_details->load_from) }}" alt="{{ __('profile-img') }}">
                            @else
                                <img src="{{ asset('assets/uploads/profile/'.$user_details->image) }}" alt="profile-img">
                            @endif
                        @else
                            <img src="{{ asset('assets/static/img/author/author.jpg') }}" alt="freelancer-image">
                        @endif
                    </div>
                    <p class="userDetails__wrapper__item"><strong>{{ __('User Type:') }}</strong>@if($user_details->user_type==1) {{ __('Client') }} @else {{ __('Freelancer') }}@endif</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Hourly Rate:') }}</strong> {{ $user_details->hourly_rate ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Full Name:') }}</strong>{{ $user_details->first_name.' '.$user_details->last_name }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Username:') }}</strong>{{ $user_details->username ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Email:') }}</strong>{{ $user_details->email ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Phone:') }}</strong>{{ $user_details->phone ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Country:') }}</strong>{{ optional($user_details->user_country)->country ?? '' }}</p>
                    @if(moduleExists('CoinPaymentGateway'))
                    @else
                        <p class="userDetails__wrapper__item"><strong>{{ __('State:') }}</strong>{{ optional($user_details->user_state)->state ?? '' }}</p>
                        <p class="userDetails__wrapper__item"><strong>{{ __('City:') }}</strong>{{ optional($user_details->user_city)->city ?? '' }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="user-identity userProfileDetails">
                <div class="userProfileDetails__header">
                    <h5 class="userProfileDetails__title">{{__('User Identity Info')}}</h5>
                </div>
                <div class="userDetails__wrapper userProfile__details mt-3">
                    <div class="userProfile__details__thumb mb-3">
                    @if(!empty($user_identity_details))
                       @if(cloudStorageExist() && in_array(Storage::getDefaultDriver(), ['s3', 'cloudFlareR2', 'wasabi']))
                            <img src="{{ render_frontend_cloud_image_if_module_exists( 'verification/'. $user_identity_details->front_image, load_from: $user_identity_details->load_from) }}" alt="{{ __('front-img') }}">
                            <img src="{{ render_frontend_cloud_image_if_module_exists( 'verification/'. $user_identity_details->back_image, load_from: $user_identity_details->load_from) }}" alt="{{ __('back_image') }}">
                        @else
                        <img style="width:150px" src="{{ asset('assets/uploads/verification/'.$user_identity_details->front_image) }}" alt="{{ __('front-img') }}">
                        <img style="width:150px" src="{{ asset('assets/uploads/verification/'.$user_identity_details->back_image) }}" alt="{{ __('back-img') }}">
                        @endif
                    </div>
                    <p class="userDetails__wrapper__item"><strong>{{ __('National ID:') }}</strong>{{ $user_identity_details->national_id_number ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Documents Type:') }}</strong>{{ $user_identity_details->verify_by ?? '' }}</p>
                    <p class="userDetails__wrapper__item"><strong>{{ __('Country:') }}</strong>{{ optional($user_identity_details->user_country)->country ?? '' }}</p>
                        @if(moduleExists('CoinPaymentGateway'))
                        @else
                        <p class="userDetails__wrapper__item"><strong>{{ __('State:') }}</strong>{{ optional($user_identity_details->user_state)->state ?? '' }}</p>
                        <p class="userDetails__wrapper__item"><strong>{{ __('City:') }}</strong>{{ optional($user_identity_details->user_city)->city ?? '' }}</p>
                        <p class="userDetails__wrapper__item"><strong>{{ __('Zipcode:') }}</strong>{{ $user_identity_details->zipcode ?? '' }}</p>
                        @endif
                    <p class="userDetails__wrapper__item"><strong>{{ __('Address:') }}</strong>{{ $user_identity_details->address ?? '' }}</p>
                    @else
                    <div class="userProfileDetails__noInfo">
                        <h3 class="userProfileDetails__noInfo__title">{{ __('No Information') }}</h3>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
