@extends('backend.layout.master')
@section('title', __('All Projects'))
@section('style')
    <x-select2.select2-css/>
@endsection
@section('content')
    <div class="dashboard__body">
        <div class="row">
            <div class="col-lg-12">
                <div class="customMarkup__single">
                    <div class="customMarkup__single__item">
                        <div class="customMarkup__single__item__flex">
                            <h4 class="customMarkup__single__title">{{ __('All Projects') }}</h4>
                        </div>
                        <div class="search_delete_wrapper">
                            <x-bulk-action.bulk-action />
                            <x-search.search-in-table :id="'string_search'" />
                        </div>
                        <div class="customMarkup__single__inner mt-4">
                            <!-- Table Start -->
                            <div class="custom_table style-04 search_result">
                                @include('backend.pages.project.search-result')
                            </div>
                            <!-- Table End -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <x-sweet-alert.sweet-alert2-js/>
    <x-bulk-action.bulk-delete-js :url="route('admin.project.delete.bulk.action')"/>
    <x-select2.select2-js/>
    @include('backend.pages.project.project-js')

@endsection
