@if(get_static_option('project_enable_disable') != 'disable')
    <!-- Project area starts -->
    <section class="project-area pat-50 pab-50" data-padding-top="{{$padding_top ?? ''}}" data-padding-bottom="{{$padding_bottom ?? ''}}" style="background-color:{{$section_bg ?? ''}}">
        <div class="container">
            <div class="section-title text-left append-flex">
               <div class="d-flex w-100 justify-content-between">
                   <h2 class="subtitle"> {{ $title ?? '' }}</h2>
                   <div>
                       @if(!empty($view_all_link) && !empty($view_all_link))
                         <a href="{{ $view_all_link }}" class="view-all-projects-jobbs">{{ $view_all_text }}</a>
                       @endif
                   </div>
               </div>
            </div>

            <div class="d-flex w-100 justify-content-between">
                <div class="section-title text-left mx-0">
                    <div class="title">
                        <span>{{ $category->category ?? '' }}</span>
                    </div>
                </div>
                <div class="append-project"></div>
            </div>

            <div class="row mt-5">
                <div class="col-12">
                    <div class="nav-style-one {{ $layout_type === 'grid' ? 'row g-4' : 'global-slick-init project-slider attraction-slider slider-inner-margin' }}"
                    data-rtl="{{get_user_lang_direction() == 'rtl' ? 'true' : 'false'}}" data-appendArrows=".append-project" data-arrows="true" data-infinite="true" data-dots="false" data-slidesToShow="3" data-swipeToSlide="true" data-autoplaySpeed="2500"
                         data-prevArrow='<div class="prev-icon"><i class="fa-solid fa-arrow-left"></i></div>'
                         data-nextArrow='<div class="next-icon"><i class="fa-solid fa-arrow-right"></i></div>'
                         data-responsive='[{"breakpoint": 1400,"settings": {"slidesToShow": 3}},{"breakpoint": 1200,"settings": {"slidesToShow": 2}},{"breakpoint": 992,"settings": {"slidesToShow": 2}},{"breakpoint": 768,"settings": {"slidesToShow": 1}},{"breakpoint": 576, "settings": {"slidesToShow": 1} }]'>
                        @if($items <= 1)
                            @foreach($explore_projects as $project)
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="project-item wow fadeInUp" data-wow-delay=".1s">
                                            <div class="single-project radius-10">
                                                <div class="single-project-thumb">
                                                    <a href="{{ route('project.details', ['username' => $project->project_creator?->username, 'slug' => $project->slug]) }}">
                                                        @if(cloudStorageExist() && in_array(Storage::getDefaultDriver(), ['s3', 'cloudFlareR2', 'wasabi']))
                                                            <img src="{{ render_frontend_cloud_image_if_module_exists( 'project/'.$project->image, load_from: $project->load_from) }}" alt="{{ $project->title ?? '' }}">
                                                        @else
                                                            <img src="{{ asset('assets/uploads/project/'.$project->image) ?? '' }}" alt="{{ $project->title ?? '' }}">
                                                        @endif
                                                    </a>
                                                </div>
                                                <div class="single-project-content">

                                                    <div class="single-project-content-top align-items-center flex-between">
                                                        @if(moduleExists('PromoteFreelancer') && $project->is_pro_project)
                                                            <div class="single-project-content-review pro-profile-badge">
                                                                <small>
                                                                    {{ get_static_option('promoted_badge_text', 'Sponsored') }}
                                                                </small>
                                                            </div>
                                                        @endif
                                                        {!! project_rating($project->id) !!}
                                                    </div>

                                                    <h4 class="single-project-content-title"> <a href="{{ route('project.details', ['username' => $project->project_creator?->username, 'slug' => $project->slug]) }}">{{ $project->title }} </a> </h4>
                                                </div>
                                                <div class="single-project-bottom flex-between">
                                                    <span class="single-project-content-price">
                                                        @if($project->basic_discount_charge)
                                                            {{ float_amount_with_currency_symbol($project->basic_discount_charge) }}
                                                            <s>{{ float_amount_with_currency_symbol($project->basic_regular_charge) }}</s>
                                                        @else
                                                            {{ float_amount_with_currency_symbol($project->basic_regular_charge) }}
                                                        @endif
                                                    </span>
                                                    <div class="single-project-delivery">
                                                        <span class="single-project-delivery-icon"> <i class="fa-regular fa-clock"></i> {{ __('Delivery') }} </span>
                                                        <span class="single-project-delivery-days"> {{ $project->basic_delivery }}  </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            @foreach($explore_projects as $project)
                                <div class="{{ $layout_type === 'grid' ? 'col-lg-4 col-md-6' : 'project-item' }} wow fadeInUp" data-wow-delay=".1s">
                                    <div class="single-project radius-10">
                                        <div class="single-project-thumb">
                                            <a href="{{ route('project.details', ['username' => $project->project_creator?->username, 'slug' => $project->slug]) }}">
                                                @if(cloudStorageExist() && in_array(Storage::getDefaultDriver(), ['s3', 'cloudFlareR2', 'wasabi']))
                                                    <img src="{{ render_frontend_cloud_image_if_module_exists( 'project/'.$project->image, load_from: $project->load_from) }}" alt="{{ $project->title ?? '' }}">
                                                @else
                                                    <img src="{{ asset('assets/uploads/project/'.$project->image) ?? '' }}" alt="{{ $project->title ?? '' }}">
                                                @endif
                                            </a>
                                        </div>
                                        <div class="single-project-content">

                                            <div class="single-project-content-top align-items-center flex-between">
                                                @if(moduleExists('PromoteFreelancer') && $project->is_pro_project)
                                                    <div class="single-project-content-review pro-profile-badge">
                                                        <small>
                                                            {{ get_static_option('promoted_badge_text', 'Sponsored') }}
                                                        </small>
                                                    </div>
                                                @endif
                                                {!! project_rating($project->id) !!}
                                            </div>

                                            <h4 class="single-project-content-title"> <a href="{{ route('project.details', ['username' => $project->project_creator?->username, 'slug' => $project->slug]) }}">{{ $project->title }} </a> </h4>
                                        </div>
                                        <div class="single-project-bottom flex-between">
                                <span class="single-project-content-price">
                                    @if($project->basic_discount_charge)
                                        {{ float_amount_with_currency_symbol($project->basic_discount_charge) }}
                                        <s>{{ float_amount_with_currency_symbol($project->basic_regular_charge) }}</s>
                                    @else
                                        {{ float_amount_with_currency_symbol($project->basic_regular_charge) }}
                                    @endif
                                </span>
                                            <div class="single-project-delivery">
                                                <span class="single-project-delivery-icon"> <i class="fa-regular fa-clock"></i> {{ __('Delivery') }} </span>
                                                <span class="single-project-delivery-days"> {{ $project->basic_delivery }}  </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Project area end -->
@endif