<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Project;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Modules\PromoteFreelancer\Entities\PromotionProjectList;
use Modules\Subscription\Http\Controllers\Frontend\FrontendSubscriptionController;

class ProjectDetailsController extends Controller
{
    public function __construct(private FrontendJobsController $jobsController, private FrontendSubscriptionController $subscriptionController)
    {
        //
    }

    //project details
    public function project_details($username, $slug = null)
    {
        if ($username == 'jobs' && $slug == "all") {
            //: now call frontendjobscontroller method jobs for getting all content
            return $this->jobsController->jobs();
        }

        if ($username == 'subscriptions' && $slug == "all") {
            //: now call FrontendSubscriptionController method subscriptions for getting all content
            return $this->subscriptionController->subscriptions();
        }

        if ($slug != 'admin') {
            $project = Project::where('slug', $slug)->first();
            if (!empty($project)) {
                $user = User::with('user_introduction', 'user_country', 'user_state', 'user_city')
                    ->where('id', $project->user_id)
                    ->where('check_work_availability', 1)
                    ->where('user_active_inactive_status', 1)
                    ->first();

                if (!$user) {
                    abort(404);
                }

                $project_complete_orders = Order::select('orders.id', 'orders.identity', 'orders.status', 'orders.is_project_job')
                    ->join('ratings', 'orders.id', '=', 'ratings.order_id')
                    ->where('orders.identity', $project->id)
                    ->where('orders.status', 3)
                    ->where('orders.is_project_job', 'project')
                    ->orderBy('ratings.created_at', 'desc')  // Newest reviews first
                    ->paginate(10);

                // pro project view count
                if (moduleExists('PromoteFreelancer')) {
                    $authId = auth('web')->id();
                    $current_date = \Carbon\Carbon::now()->toDateTimeString();

                    $find_package = PromotionProjectList::where('identity', $project->id)
                        ->where('type', 'project')
                        ->where('expire_date', '>=', $current_date)
                        ->first();

                    if ($find_package) {
                        if (!$authId || $authId !== $project->user_id) {
                            PromotionProjectList::where('id', $find_package->id)
                                ->update(['click' => $find_package->click + 1]);
                        }
                    }
                }
            } else {
                return back();
            }
            return  view('frontend.pages.project-details.project-details', compact(['project', 'user', 'project_complete_orders']));
        } else {
            return view('backend.pages.auth.login');
        }
    }

    //load more review
    public function load_more_review(Request $request)
    {
        $project_id = $request->project_id;
        $project_complete_orders = Order::select('orders.id', 'orders.identity', 'orders.status', 'orders.is_project_job')
            ->join('ratings', 'orders.id', '=', 'ratings.order_id')
            ->where('orders.identity', $project_id)
            ->where('orders.status', 3)
            ->where('orders.is_project_job', 'project')
            ->orderBy('ratings.created_at', 'desc')  // Newest reviews first
            ->paginate(10);
        return view('frontend.pages.project-details.reviews', compact(['project_complete_orders', 'project_id']))->render();
    }
}
