<?php

use Illuminate\Support\Facades\Route;
use Modules\Community\App\Http\Controllers\Frontend\AnsweReplyController;
use Modules\Community\App\Http\Controllers\Frontend\QuestionTipController;
use Modules\Community\App\Http\Controllers\Frontend\ReactionController;
use Modules\Community\App\Http\Controllers\FrontendCommunityController;
use Modules\Community\App\Http\Controllers\Backend\CommunityController;

//admin route
Route::group(['as'=>'admin.community.','prefix'=>'admin/community','middleware' => ['auth:admin','setlang']],function() {
        Route::controller(CommunityController::class)->group(function () {
            Route::get('question/all', 'question_tips')->name('question.tip.all');
            Route::get('question/search-job', 'search_question_tip')->name('question.tip.search');
            Route::get('paginate/data', 'pagination')->name('question.paginate.data');
            Route::match(['get','post'],'page/settings', 'page_settings')->name('page.settings');
            Route::post('change-status/{id}', 'change_status')->name('question.status.change');
            Route::post('delete/{id}','delete_question_tip')->name('question.tip.delete');
        });
});

//user route
Route::group(['prefix'=>'community','as'=>'community.','middleware'=>['auth','userEmailVerify','Google2FA','globalVariable', 'maintains_mode','setlang']],function() {
    Route::controller(QuestionTipController::class)->group(function () {
        Route::post('community/question-post','question_post')->name('question.tips.post');
        Route::post('community/question-post-edit','question_post_edit')->name('question.tips.post.edit');
        Route::post('community/delete/{id}','delete_question')->name('question.delete');
    });
});

//user route
Route::group(['prefix'=>'reaction','as'=>'reaction.','middleware'=>['auth','userEmailVerify','Google2FA','globalVariable', 'maintains_mode','setlang']],function() {
    Route::controller(ReactionController::class)->group(function () {
        Route::post('for/question','reaction_for_question')->name('question');
        Route::post('for/question-answer','reaction_for_question_answer')->name('question.answer');
    });
});

Route::group(['prefix'=>'reply','as'=>'reply.','middleware'=>['auth','userEmailVerify','Google2FA','globalVariable', 'maintains_mode','setlang']],function() {
    Route::controller(AnsweReplyController::class)->group(function () {
        Route::post('for/answer','answer_reply')->name('question.answer');
        Route::post('for/answer/edit','answer_reply_edit')->name('question.answer.edit');
    });
});


//frontend route
Route::group(['middleware' => ['globalVariable', 'maintains_mode','setlang']], function () {
    Route::controller(FrontendCommunityController::class)->group(function(){
        Route::get('community/all', 'community')->name('community.all');
        Route::get('community/search', 'search')->name('community.search');
        Route::get('community/question/all', 'question_all')->name('community.question.all');
        Route::get('community/tips/all', 'tips_all')->name('community.tip.all');
        Route::get('community/question/{slug}', 'question_details')->name('community.question.details');
        Route::post('community/question/answer/client-freelancer', 'question_answer')->name('community.question.answer');
        Route::post('community/question/answer/edit', 'question_answer_edit')->name('community.question.answer.edit');
        Route::get('community/question/answer/get', 'paginate')->name('community.question.answer.paginate');
    });
});

