@if($question_answers->total() > 0)
    @if($question_details->type == 'question')
        <h4>{{ __('Answers') }} ({{ $question_answers->total() }})</h4>
    @else
        <h4>{{ __('Comments') }} ({{ $question_answers->total() }})</h4>
    @endif
    @foreach($question_answers as $answer)

    <div class="single-profile-settings mt-5">
        <div class="ask-questions">
            <div class="ask-questions-contents-author">
                <div class="ask-questions-contents-author-flex">
                    <div class="ask-questions-contents-author-thumb">
                        @if(!empty($answer?->user?->image))
                            <img src="{{ asset('assets/uploads/profile/'.$answer?->user?->image ?? '') }}" alt="AuthorImg">
                        @else
                            <img src="{{ asset('assets/static/img/author/author.jpg') }}" alt="AuthorImg">
                        @endif
                    </div>
                    <div class="ask-questions-contents-author-details">
                        <h4 class="ask-questions-contents-author-details-title">{{ $answer?->user?->full_name ?? '' }}</h4>
                        <span class="ask-questions-contents-author-details-time mt-2"> {{ $answer->created_at->diffForHumans() }}
                            @if($question_details->type == 'question')
                                @if($question_details->question_user_id == $answer->user_id) <span class="opacity-75"> - {{ __('Self Answered') }}</span> @endif
                            @else
                                @if($question_details->question_user_id == $answer->user_id) <span class="opacity-75"> - {{ __('Self Comment') }}</span> @endif
                            @endif
                        </span>


                        <div class="answer_short_description" id="answer_short_description_{{ $answer->id }}">
                            <p class="ask-questions-contents-author-details-para mt-3">
                                {!! Str::limit(strip_tags($answer->answer), 120) !!}
                                @if(Str::length(strip_tags($answer->answer)) > 120)
                                    <span class="answer_show_more" data-id="{{ $answer->id }}"> <i class="fa-solid fa-angle-down fs-5"></i></span>
                                @endif
                            </p>
                        </div>
                        <div class="answer_full_description" id="answer_full_description_{{ $answer->id }}">
                            <p class="ask-questions-contents-author-details-para mt-3">
                                {!! $answer->answer ?? '' !!}
                                <span class="answer_show_less" id="answer_show_less_{{ $answer->id }}" data-id="{{ $answer->id }}"> <i class="fa-solid fa-angle-up fs-5"></i></span>
                            </p>
                        </div>
                    </div>

                    @if(Auth::guard('web')->check() && $question_details->question_user_id == Auth::guard('web')->user()->id && $answer?->answer_reply_count <= 0)
                        <div class="reply_button" data-bs-target="#answer_reply_modal_{{$answer->id}}" data-bs-toggle="modal">
                            <span class="btn opacity-25">
                                <i class="fa-solid fa-reply"></i>
                            </span>
                        </div>
                        @include('community::frontend.question.reply-modal')
                    @endif

                    @if(Auth::guard('web')->check() && $answer->user_id == Auth::guard('web')->user()->id)
                        <span class="answer_edit_button"
                             data-id="{{ $answer->id }}"
                             data-answer="{{ $answer->answer }}"
                             data-bs-target="#answer_edit_modal_{{$answer->id}}"
                             data-bs-toggle="modal">
                            <span class="btn opacity-25">
                                <i class="fa-solid fa-edit"></i>
                            </span>
                        </span>
                        @include('community::frontend.question.answer-edit-modal')
                    @endif

                </div>
                <div id="answer_reaction_wrapper_{{$answer->id}}">
                    <div class="d-flex justify-content-end align-items-center gap-2 profile-border-top">
                        <div class="reactions text-end fs-6" >
                            @if($answer->answer_like_reaction_count >= 1)
                                <span class="given-reactions">
                            <i class="fa-solid fa-heart text-danger"></i> <span>{{ $answer->answer_like_reaction_count }}</span> &nbsp;
                            </span>
                            @endif
                            @if($answer->answer_sad_reaction_count >= 1)
                                <span class="given-reactions">
                            <i class="fa-solid fa-face-sad-tear text-warning"></i> <span>{{ $answer->answer_sad_reaction_count }}</span> &nbsp;
                            </span>
                            @endif
                            @if($answer->answer_up_reaction_count >= 1)
                                <span class="given-reactions">
                            <i class="fa-regular fa-circle-up text-primary"></i> <span>{{ $answer->answer_up_reaction_count }}</span>
                            </span>
                            @endif
                            @if($answer->answer_support_reaction_count >= 1)
                                <span class="given-reactions">
                            <i class="fas fa-life-ring text-info"></i> <span>{{ $answer->answer_support_reaction_count }}</span>
                            </span>
                            @endif
                            @if($answer->answer_congrats_reaction_count >= 1)
                                <span class="given-reactions">
                            <i class="fa-solid fa-sun text-success"></i> <span>{{ $answer->answer_congrats_reaction_count }}</span>
                            </span>
                            @endif
                        </div>
                        <div class="position-relative">

                            @if(Auth::guard('web')->check())
                                <div class="choose_answer_reaction" onclick="toggleAnswerReactionList({{$answer->id}})">
                                    <i class="fa-solid fa-heart"></i>
                                </div>
                            @else
                                <div class="choose_answer_reaction" data-bs-toggle="tooltip" data-bs-placement="bottom" title="{{ __('Login please') }}">
                                    <i class="fa-solid fa-heart"></i>
                                </div>
                            @endif

                            <div class="answer_reaction_list flex-column" id="answerReactionList_{{$answer->id}}">
                                <div class="reaction_item" data-reaction="like" data-answer_id="{{ $answer->id }}">
                                    <span class="d-flex justify-content-between align-items-center"> <span>{{ __('Love') }}</span> <i class="fa-solid fa-heart text-danger"></i></span>
                                </div>
                                <div class="reaction_item" data-reaction="sad" data-answer_id="{{ $answer->id }}">
                                    <span class="d-flex justify-content-between align-items-center"> <span>{{ __('Sad') }}</span> <i class="fa-solid fa-face-sad-tear text-warning"></i></span>
                                </div>
                                <div class="reaction_item up" data-reaction="up" data-answer_id="{{ $answer->id }}">
                                    <span class="d-flex justify-content-between align-items-center"> <span>{{ __('Up') }}</span> <i class="fa-regular fa-circle-up text-primary"></i></span>
                                </div>
                                <div class="reaction_item" data-reaction="support" data-answer_id="{{ $answer->id }}">
                                    <span class="d-flex justify-content-between align-items-center"> <span>{{ __('Support') }}</span> <i class="fas fa-life-ring text-info"></i></span>
                                </div>
                                <div class="reaction_item" data-reaction="congrats" data-answer_id="{{ $answer->id }}">
                                    <span class="d-flex justify-content-between align-items-center"> <span>{{ __('Congrats') }}</span> <i class="fa-solid fa-sun text-success"></i></span>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--answer reply--}}
    <div class="author_reoly">
        <div class="mt-2 reload_after_reply_in_answer_{{$answer->id}}">
            @include('community::frontend.question.author-reply-for-answer')
        </div>
    </div>

    @endforeach
    <div class="deposit-history-pagination">
        <x-pagination.laravel-paginate :allData="$question_answers"/>
    </div>
@endif