<script>
    (function($){
        "use strict";
        $(document).ready(function(){
            $('.full_description').hide();
            $('.answer_full_description').hide();

            function initializeSummernote_after_paginate(element, options) {
                element.summernote($.extend({
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert', ['link']],
                    ],
                    callbacks: {
                        onPaste: function(e) {
                            var bufferText = ((e.originalEvent || e).clipboardData || window
                                .clipboardData).getData('Text');
                            e.preventDefault();
                            document.execCommand('insertText', false, bufferText);
                        }
                    },
                    height: 100
                }, options));
            }

            // Show more functionality
            $(document).on('click', '.show_more', function() {
                $('.short_description').hide();
                $('.full_description').slideDown(1000);
                $('.full_description').show();
            });

            // Show less functionality
            $(document).on('click', '.show_less', function() {
                $('.full_description').hide();
                $('.short_description').show();
            });

            // Answer Show more functionality
            $(document).on('click', '.answer_show_more', function() {
                let answerId = $(this).data('id');
                $('#answer_short_description_' + answerId).hide();
                $('#answer_full_description_' + answerId).slideDown(1000);
                $('#answer_full_description_' + answerId).show();
                $('#answer_show_less_' + answerId).show();
            });

            // Answer Show less functionality
            $(document).on('click', '.answer_show_less', function() {
                let answerId = $(this).data('id');
                $('#answer_full_description_' + answerId).hide();
                $('#answer_short_description_' + answerId).show();
                $('#answer_show_more_' + answerId).show();
            });

            // pagination
            $(document).on('click', '.pagination a', function(e){
                e.preventDefault();

                let page = $(this).attr('href').split('page=')[1];
                let question_id = $('#question_id').val();
                answers(page,question_id);
            });
            function answers(page,question_id){
                $.ajax({
                    url:"{{ route('community.question.answer.paginate').'?page='}}" + page,
                    data:{question_id:question_id},
                    success:function(res){
                        $('.search_answers').html(res);
                        initializeSummernote_after_paginate($('.description'), {
                            height: 100
                        });
                    }
                });
            }

            // question answer
            $(document).on('click','.send_reply',function(){
                let answer = $('#answer').val();
                let question_id = $('#question_id').val();
                let erContainer = $(".error-message");
                erContainer.html('');
                $.ajax({
                    url:"{{ route('community.question.answer') }}",
                    method:'post',
                    data:{answer:answer,question_id:question_id},
                    error:function(res){
                        let errors = res.responseJSON;
                        erContainer.html('<div class="alert alert-danger"></div>');
                        $.each(errors.errors, function(index,value){
                            erContainer.find('.alert.alert-danger').append('<p>'+value+'</p>');
                        });
                    },
                    success:function(res){
                        console.log(res)
                        toastr_success_js("{{__('Answer submitted.') }}")
                        $(".search_answers").html(res);
                        $('#answer').summernote('reset');
                        $('.answer_full_description').hide();
                    }
                });
            })

            // show question answer
            $(document).on('click','.answer_edit_button',function(e) {
                let answer_id = $(this).data('id');
                let answer = $(this).data('answer');
                $(`#answer_edit_${answer_id}`).summernote('code', answer);
                initializeSummernote_after_paginate($('.description'), {
                    height: 100
                });
            });

            //edit answer
            $(document).on('click','#submit_answer_edit',function(e){
                e.preventDefault();
                let answer_id = $(this).data('answer_id');
                let question_tip_id = $(this).data('question_tip_id');
                let answer = $(`#answer_edit_${answer_id}`).val();

                if(answer == ''){
                    toastr_warning_js("{{ __('Description field is required.') }}")
                    return false;
                }else{
                    $.ajax({
                        url:"{{ route('community.question.answer.edit') }}",
                        method:'post',
                        data:{answer_id:answer_id,question_tip_id:question_tip_id,answer:answer},
                        success:function(res){
                            $(`#answer_edit_${answer_id}`).summernote('reset');
                            $('.answer_edit_modal').modal('hide');
                            $('.modal-backdrop').remove();
                            $('.search_answers').html(res)
                            initializeSummernote_after_paginate($('.description'), {
                                height: 100
                            });
                            $('.answer_full_description').hide();
                            toastr_success_js("{{__('Answer successfully updated.')}}")
                        }
                    });
                }
            })

            // question reactions
            $(document).on('click','.reactions .reaction_item',function(){
                let reaction = $(this).data('reaction')
                let question_id = $('#question_id').val();
                $.ajax({
                    url:"{{ route('reaction.question') }}",
                    method:'post',
                    data:{reaction:reaction,question_id:question_id},
                    success:function(res){
                        if(res.status=='success'){
                            $(".reaction_wrapper").load(location.href + ' .reaction_wrapper');
                            $(".voating").load(location.href + ' .voating');
                            toastr_success_js("{{__('Reaction successfully added.')}}")
                        }
                    }
                });
            })

            //answer reactions
            $(document).on('click','.answer_reaction_list .reaction_item',function(){
                let reaction = $(this).data('reaction');
                let question_id = $('#question_id').val();
                let answer_id = $(this).data('answer_id');
                $.ajax({
                    url:"{{ route('reaction.question.answer') }}",
                    method:'post',
                    data:{reaction:reaction,question_id:question_id,answer_id:answer_id},
                    success:function(res){
                        if(res.status=='success'){
                            $("#answer_reaction_wrapper_"+res.answer_id).load(location.href + ' #answer_reaction_wrapper_'+res.answer_id);
                            toastr_success_js("{{__('Answer Reaction successfully added.')}}")
                        }
                    }
                });
            })

            //question answer reply
            $(document).on('click','#submit_answer_reply',function(e){
                e.preventDefault();
                let answer_id = $(this).data('answer_id');
                let question_tip_id = $(this).data('question_tip_id');
                let answer_reply = $(`#answer_reply_${answer_id}`).val();

                if(answer_reply == ''){
                    toastr_warning_js("{{ __('Description field is required.') }}")
                    return false;
                }else{
                    $.ajax({
                        url:"{{ route('reply.question.answer') }}",
                        method:'post',
                        data:{answer_id:answer_id,question_id:question_tip_id,answer_reply:answer_reply},
                        success:function(res){
                            $(".reload_after_reply_in_answer_"+answer_id).html(res);
                            $(`#answer_reply_${answer_id}`).summernote('reset');
                            $('.answer_reply_modal').modal('hide');
                            initializeSummernote_after_paginate($('.description'), {
                                height: 100
                            });
                            toastr_success_js("{{__('Reply successfully added.')}}")
                        }
                    });
                }
            })

            //show reply in description
            $(document).on('click','.edit_author_reply',function(e) {
                let reply = $(this).data('reply');
                let answer_id = $(this).data('answer_id');
                $(`#edit_answer_reply_${answer_id}`).summernote('code', reply);
            });

            //edit answer reply
            $(document).on('click','#submit_answer_reply_edit',function(e){
                e.preventDefault();
                let reply_id = $(this).data('id');
                let answer_id = $(this).data('answer_id');
                let answer_reply = $(`#edit_answer_reply_${answer_id}`).val();

                if(answer_reply == ''){
                    toastr_warning_js("{{ __('Description field is required.') }}")
                    return false;
                }else{
                    $.ajax({
                        url:"{{ route('reply.question.answer.edit') }}",
                        method:'post',
                        data:{answer_id:answer_id,reply_id:reply_id,answer_reply:answer_reply},
                        success:function(res){
                            $(".reload_after_reply_in_answer_"+answer_id).html(res);
                            initializeSummernote_after_paginate($('.description'), {
                                height: 100
                            });
                            $(`#edit_answer_reply_${answer_id}`).summernote('reset');
                            $('.answer_reply_edit_modal').modal('hide');
                            $('.modal-backdrop').remove();
                            toastr_success_js("{{__('Reply successfully updated.')}}")
                        }
                    });
                }
            })

        });
    }(jQuery));

    // toastr warning
    function toastr_warning_js(msg){
        Command: toastr["warning"](msg, "Warning !")
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    }
    //toastr success
    function toastr_success_js(msg){
        Command: toastr["success"](msg, "Success !")
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }
    }
</script>
