@extends('frontend.layout.master')
@section('site_title', __('Community'))
@section('meta_title'){{ __('Community') }}@endsection
@section('style')
    <x-summernote.summernote-css/>
    <style>
        /*question reaction*/
        .reaction_list {
            padding-left:10px;
            border-left: 2px solid var(--main-color-one);
            width:120px;
            display: none;
            position: absolute;
            bottom: 35px;
            right: 0;
            background-color: #f8f9fa;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            z-index: 100;
        }

        .reaction_list .reaction_item {
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
            cursor: pointer;
        }

        .reaction_list .reaction_item:last-child {
            margin-bottom: 0;
        }

        .choose_reaction, .choose_answer_reaction{
            cursor: pointer;
            border-left: 1px solid #D0CACA;
            margin-left: 10px;
            padding-left: 10px;
        }

        .choose_reaction i, .choose_answer_reaction i {
            border: 1px solid #D0CACA;
            padding: 6px;
            border-radius: 50%;
            background: #D0CACA;
            color: #fff;
        }

        .show_more, .show_less{
            cursor:pointer;
        }

        /*question answer reaction*/
        .answer_reaction_list {
            padding-left: 10px;
            border-left: 2px solid var(--main-color-one);
            width:120px;
            display: none;
            position: absolute;
            bottom: 35px;
            right: 0;
            background-color: #f8f9fa;
            border-radius: 10px;
            padding: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            z-index: 100;
        }

        .answer_reaction_list .reaction_item {
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
            cursor: pointer;
        }

        .answer_reaction_list .reaction_item:last-child {
            margin-bottom: 0;
        }

        .choose_answer_reaction {
            cursor: pointer;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .ask-questions-header {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .voating {
            font-size: 1.2rem;
            display: flex;
            flex-direction: column;
            padding: 15px;
            text-align: center;
            border-radius: 8px;
        }
        .given-reactions {
            border: 1px solid #D0CACA;
            border-radius: 100px;
            padding: 0 10px;
        }
        .borderrr-top{
            border-top: 1px solid #D0CACA;
            padding-top:24px;
            margin-top:24px;
        }
    </style>
@endsection
@section('content')
    <main>
        @if(moduleExists('CoinPaymentGateway'))@else<x-frontend.category.category/>@endif
        <x-breadcrumb.user-profile-breadcrumb :title="__('Community') ?? __('Community')" :innerTitle="__('Question Details') ?? ''" />
        <div class="profile-settings-area pat-100 pab-100 section-bg-2">
            <div class="container">
                <div class="row g-4">
                    <div class="col-lg-8">
                        <div class="profile-settings-wrapper">
                            <div class="single-profile-settings">
                                <div class="ask-questions">
                                    <div class="ask-questions-header">
                                        <div class="voating">
                                            <i class="fa-solid fa-angle-up"></i>
                                                {{ $question_details->question_up_reaction_count}}
                                            <i class="fa-solid fa-angle-down"></i>
                                        </div>
                                        <div>
                                            <h4 class="ask-questions-header-title">{{ $question_details->title ?? '' }} </h4>
                                            @if($question_details->type == 'question')
                                                <p>{{ __('Ask by') }} {{ $question_details?->user?->username ?? "" }}</p>
                                            @else
                                                <p>{{ __('Share by') }} {{ $question_details?->user?->username ?? "" }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="ask-questions-contents profile-border-top">
                                        <div class="ask-questions-contents-author">
                                            <div class="ask-questions-contents-author-flex">
                                                <div class="ask-questions-contents-author-thumb">
                                                    <img src="{{asset('assets/uploads/profile/'.$question_details?->user?->image)}}" alt="{{__('AuthorImg')}}">
                                                </div>
                                                <div class="ask-questions-contents-author-details">
                                                    <h4 class="ask-questions-contents-author-details-title">{{ $question_details?->user?->fullname }}
                                                        <span class="activities">{{ __('Helping Hand') }}</span>
                                                    </h4>
                                                    <span class="ask-questions-contents-author-details-time mt-1"> {{ $question_details->created_at->diffForHumans() }} </span>

                                                    <div class="short_description">
                                                        <p class="ask-questions-contents-author-details-para mt-3">
                                                            {!! Str::limit($question_details->description ?? '', 120) !!}
                                                            <span class="show_more"> <i class="fa-solid fa-angle-down fs-5"></i></span>
                                                        </p>
                                                    </div>
                                                    <div class="full_description">
                                                        <p class="ask-questions-contents-author-details-para mt-3">
                                                            {!! $question_details->description ?? '' !!}
                                                            <span class="show_less"> <i class="fa-solid fa-angle-up fs-5"></i></span>
                                                        </p>
                                                    </div>

                                                    <div class="reaction_wrapper">
                                                        <div class="reactions d-flex justify-content-end align-items-center gap-2 text-end fs-6 position-relative profile-border-top">
                                                            @if($question_details->question_like_reaction_count >= 1)
                                                                <span class="given-reactions">
                                                                <i class="fa-solid fa-heart text-danger"></i> <span>{{ $question_details->question_like_reaction_count }}</span> &nbsp;
                                                                </span>
                                                            @endif
                                                            @if($question_details->question_sad_reaction_count >= 1)
                                                                <span class="given-reactions">
                                                                <i class="fa-solid fa-face-sad-tear text-warning"></i> <span>{{ $question_details->question_sad_reaction_count }}</span> &nbsp;
                                                                </span>
                                                            @endif
                                                            @if($question_details->question_up_reaction_count >= 1)
                                                                <span class="given-reactions">
                                                                <i class="fa-regular fa-circle-up text-primary"></i> <span>{{ $question_details->question_up_reaction_count }}</span>
                                                                </span>
                                                            @endif
                                                            @if($question_details->question_support_reaction_count >= 1)
                                                                <span class="given-reactions">
                                                                <i class="fas fa-life-ring text-info"></i> <span>{{ $question_details->question_support_reaction_count }}</span>
                                                                </span>
                                                            @endif
                                                            @if($question_details->question_congrats_reaction_count >= 1)
                                                                <span class="given-reactions">
                                                                <i class="fa-solid fa-sun text-success"></i> <span>{{ $question_details->question_congrats_reaction_count }}</span>
                                                                </span>
                                                            @endif
                                                            @if(Auth::guard('web')->check())
                                                                <div class="choose_reaction" onclick="toggleReactionList()">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </div>
                                                            @else
                                                                <div class="choose_answer_reaction" data-bs-toggle="tooltip" data-bs-placement="bottom" title="{{ __('Login please') }}">
                                                                    <i class="fa-solid fa-heart"></i>
                                                                </div>
                                                            @endif
                                                            <div class="reaction_list flex-column" id="reactionList">
                                                                <div class="reaction_item" data-reaction="like">
                                                                    <span class="d-flex justify-content-between align-items-center"><span>{{ __('Love') }}</span> <i class="fa-solid fa-heart text-danger"></i></span>
                                                                </div>
                                                                <div class="reaction_item" data-reaction="sad">
                                                                    <span class="d-flex justify-content-between align-items-center"><span>{{ __('Sad') }}</span> <i class="fa-solid fa-face-sad-tear text-warning"></i></span>
                                                                </div>
                                                                <div class="reaction_item up" data-reaction="up">
                                                                    <span class="d-flex justify-content-between align-items-center"><span>{{ __('Up') }}</span> <i class="fa-regular fa-circle-up text-primary"></i></span>
                                                                </div>
                                                                <div class="reaction_item up" data-reaction="support">
                                                                    <span class="d-flex justify-content-between align-items-center"><span>{{ __('Support') }}</span> <i class="fas fa-life-ring text-info"></i></span>
                                                                </div>
                                                                <div class="reaction_item up" data-reaction="congrats">
                                                                    <span class="d-flex justify-content-between align-items-center"><span>{{ __('Congrats') }}</span> <i class="fa-solid fa-sun text-success"></i></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="profile-settings-wrapper mt-5 all_reply search_answers">
                           @include('community::frontend.question.search-answers')
                        </div>
                        @include('community::frontend.question.answer-form')
                    </div>
                    @include('community::frontend.question.sidebar')
                </div>
            </div>
        </div>
    </main>
@endsection

@section('script')
    <script src="{{asset('assets/backend/js/summernote/summernote-lite.min.js')}}"></script>
    <script>
        function initializeSummernote(element, options) {
            element.summernote($.extend({
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                ],
                height: 100
            }, options));
        }
        //use
        initializeSummernote($('.description'), {
            height: 100
        });

        //question reaction
        function toggleReactionList() {
            const $reactionList = $("#reactionList");
            if ($reactionList.is(":visible")) {
                $reactionList.fadeOut(300);
            } else {
                $reactionList.fadeIn(300);
            }
        }

        //answer reaction
        function toggleAnswerReactionList(id=null) {
            const $reactionList = $("#answerReactionList_"+id);
            if ($reactionList.is(":visible")) {
                $reactionList.fadeOut(300);
            } else {
                $reactionList.fadeIn(300);
            }
        }

        // Close the reaction list when clicking outside
        $(document).on("click", function (e) {
            const $reactionList = $("#reactionList");
            const $chooseReaction = $(".choose_reaction");
            const $choose_answer_reaction = $(".choose_answer_reaction");
            const $answer_reaction_list = $(".answer_reaction_list");

            if (
                !$chooseReaction.is(e.target) &&
                $chooseReaction.has(e.target).length === 0 &&
                !$reactionList.is(e.target) &&
                $reactionList.has(e.target).length === 0
            ) {
                $reactionList.fadeOut(300);
            }

            if (
                !$choose_answer_reaction.is(e.target) &&
                $choose_answer_reaction.has(e.target).length === 0 &&
                !$answer_reaction_list.is(e.target) &&
                $answer_reaction_list.has(e.target).length === 0
            ) {
                $answer_reaction_list.fadeOut(300);
            }
        });

    </script>
    @include('community::frontend.question.question-js')
@endsection
