<div class="profile-settings-wrapper mt-5">
    <div class="single-profile-settings">
        <div class="ask-questions">
            @if(Auth::guard('web')->check())
                <div class="ask-questions-contents-author">
                    <div class="ask-questions-contents-author-flex">
                        <div class="ask-questions-contents-author-thumb">
                            @if(!empty(Auth::guard('web')->user()->image))
                                <img src="{{ asset('assets/uploads/profile/'.Auth::guard('web')->user()->image ?? '') }}" alt="{{ __('AuthorImg') }}">
                            @else
                                <img src="{{ asset('assets/static/img/author/author.jpg') }}" alt="{{ __('AuthorImg') }}">
                            @endif
                        </div>
                        <div class="ask-questions-contents-author-form">
                            <div class="error-message"></div>
                            <form action="#" id="answer_form">
                                <input type="hidden" name="question_id" id="question_id" value="{{$question_details->id ?? ''}}">
                                <textarea name="answer" id="answer" cols="30" rows="2" class="w-100 description"></textarea>
                                <div class="btn-wrapper mt-2">
                                    @if($question_details->type == 'question')
                                        <a href="javascript:void(0)" class="btn-profile btn-bg-1 send_reply">{{ __('Reply') }}</a>
                                    @else
                                        <a href="javascript:void(0)" class="btn-profile btn-bg-1 send_reply">{{ __('Post Comment') }}</a>
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            @else
                <div class="ask-questions-contents-author text-center">
                    <div class="ask-questions-contents-author-flex">
                        <div class="ask-questions-contents-author-form my-3">
                            <input type="hidden" name="question_id" id="question_id" value="{{$question_details->id ?? ''}}">
                            <h4>{{ __('Please log in to comment') }}</h4>
                            <p class="mt-2">{{ __('You will be able to leave a comment after login') }}</p>
                            <a href="{{ route('user.login') }}" class="btn btn-primary mt-4">{{ __('Log In Now') }}</a>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>