@extends('frontend.layout.master')
@section('site_title', __('All Questions'))
@section('meta_title'){{ __('Questions') }}@endsection
@section('style')
    <x-summernote.summernote-css/>

    <style>
        .vote-borders {
            font-weight: 500;
            font-size: 1rem;
            span:first-child{
                border-right: 1px solid #D0CACA;
                padding-right: 10px;
                margin-right: 10px;
            }
        }
    </style>

@endsection
@section('content')
    <main>
        @if(moduleExists('CoinPaymentGateway'))@else<x-frontend.category.category/>@endif
        <x-breadcrumb.user-profile-breadcrumb :title="__('Questions') ?? __('Questions')" :innerTitle="__('Questions') ?? ''" />
        <div class="profile-settings-area pat-100 pab-100 section-bg-2">
            <div class="container">
                <div class="row g-4">
                    <div class="col-12">
                        <div class="question-answer mb-5">
                            <div class="question-answer-flex">
                                <div class="question-answer-item">
                                    <div class="question-answer-item-icon">
                                        <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M31.6641 14.5833C28.2141 14.5833 25.4141 11.7833 25.4141 8.33325C25.4141 4.88325 28.2141 2.08325 31.6641 2.08325C35.1141 2.08325 37.9141 4.88325 37.9141 8.33325C37.9141 11.7833 35.1141 14.5833 31.6641 14.5833ZM31.6641 4.58325C29.5974 4.58325 27.9141 6.26659 27.9141 8.33325C27.9141 10.3999 29.5974 12.0833 31.6641 12.0833C33.7307 12.0833 35.4141 10.3999 35.4141 8.33325C35.4141 6.26659 33.7307 4.58325 31.6641 4.58325Z" fill="white"/>
                                            <path d="M19.9974 22.9167H11.6641C10.9807 22.9167 10.4141 22.3501 10.4141 21.6667C10.4141 20.9834 10.9807 20.4167 11.6641 20.4167H19.9974C20.6807 20.4167 21.2474 20.9834 21.2474 21.6667C21.2474 22.3501 20.6807 22.9167 19.9974 22.9167Z" fill="white"/>
                                            <path d="M26.6641 29.5833H11.6641C10.9807 29.5833 10.4141 29.0166 10.4141 28.3333C10.4141 27.6499 10.9807 27.0833 11.6641 27.0833H26.6641C27.3474 27.0833 27.9141 27.6499 27.9141 28.3333C27.9141 29.0166 27.3474 29.5833 26.6641 29.5833Z" fill="white"/>
                                            <path d="M25.0026 37.9166H15.0026C5.9526 37.9166 2.08594 34.0499 2.08594 24.9999V14.9999C2.08594 5.94992 5.9526 2.08325 15.0026 2.08325H23.3359C24.0193 2.08325 24.5859 2.64992 24.5859 3.33325C24.5859 4.01659 24.0193 4.58325 23.3359 4.58325H15.0026C7.31927 4.58325 4.58594 7.31659 4.58594 14.9999V24.9999C4.58594 32.6833 7.31927 35.4166 15.0026 35.4166H25.0026C32.6859 35.4166 35.4193 32.6833 35.4193 24.9999V16.6666C35.4193 15.9833 35.9859 15.4166 36.6693 15.4166C37.3526 15.4166 37.9193 15.9833 37.9193 16.6666V24.9999C37.9193 34.0499 34.0526 37.9166 25.0026 37.9166Z" fill="white"/>
                                        </svg>
                                    </div>
                                    <div class="question-answer-item-contents">
                                        <h4 class="question-answer-item-contents-title">{{ __('Questions') }}</h4>
                                        <div class="question-answer-item-contents-btn mt-3">
                                            <p>{{get_static_option('community_question_page_subtitle') ?? __('This is a space for both clients and freelancers to get their questions answered by the community.') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{--question tips--}}
                <div class="row g-4 question-tips-wrapper">
                    @if(!empty($user_questions))
                         <div class="col-12">
                                <div class="single-profile-settings">
                                    <div class="single-profile-settings-header">
                                        <div class="single-profile-settings-header-flex">
                                            <a href="#/" class="btn-profile btn-bg-1"> {{ __('All Question') }} </a>
                                        </div>
                                    </div>
                                    <div class="single-profile-settings-inner profile-border-top">
                                            <table class="table">
                                                <tbody>
                                                @foreach($user_questions as $question)
                                                    <tr>
                                                        <td>
                                                            <a href="{{ route('community.question.details',$question?->slug) }}">
                                                                <span class="d-flex gap-2">
                                                                    <i class="fa-solid fa-circle-question fs-5 text-primary"></i>
                                                                    <span>
                                                                        <h4 class="label-title"> {{ ucfirst($question->title) }}</h4>
                                                                        <p>{{ __('Asked by') }}{{  $question?->user->username }}, {{ $question->created_at?->toFormattedDateString() }}</p>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </td>
                                                        <td class="vote-borders">

                                                            <span>{{ __('Votes') }} {{ $question->question_up_reaction_count }}</span>
                                                            <span>{{ __('Answers') }} {{ $question->answer_count }}</span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                            <div class="deposit-history-pagination mt-4">
                                                <x-pagination.laravel-paginate :allData="$user_questions"/>
                                            </div>
                                    </div>
                                </div>
                            </div>
                    @endif
                </div>

            </div>
        </div>
        </div>

        @include('community::frontend.question-modal')
    </main>
@endsection

@section('script')
    <x-summernote.summernote-js-function />
    <x-sweet-alert.sweet-alert2-js/>

    <script>
        initializeSummernote($('.description'), {})

        $(document).on('click','#submit_question',function (){
            let title_min_length = 10;
            let description_min_length = 50;
            let type = $('#type').val();
            let title_length = $('#title').val().length;
            let description_length = $('#description').val().length;

            if(type == '' || title_length == '' || description_length == ''){
                toastr_warning_js("{{'All fields are required'}}");
                return false;
            }else{
                if(title_length < title_min_length || title_length > 100){
                    toastr_warning_js("{{'Title must be between 10 to 100 character.'}}");
                    return false;
                }
                if(description_length < description_min_length){
                    toastr_warning_js("{{'Description must be greater than or equal to 50.'}}");
                    return false;
                }
            }
        })

        $(document).on('click','#submit_question_edit',function (){
            let title_min_length = 10;
            let description_min_length = 50;
            let type = $('#edit_type').val();
            let title_length = $('#edit_title').val().length;
            let description_length = $('#edit_description').val().length;

            if(type == '' || title_length == '' || description_length == ''){
                toastr_warning_js("{{'All fields are required'}}");
                return false;
            }else{
                if(title_length < title_min_length || title_length > 100){
                    toastr_warning_js("{{'Title must be between 10 to 100 character.'}}");
                    return false;
                }
                if(description_length < description_min_length){
                    toastr_warning_js("{{'Description must be greater than or equal to 50.'}}");
                    return false;
                }
            }
        })

        //delete question
        $(document).on('click','.delete_question',function(e){
            e.preventDefault();
            Swal.fire({
                title: '{{__("Are you sure to delete?")}}',
                text: '{{__("You would not be able to revert this item!")}}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{__('Yes, Delete it!')}}"
            }).then((result) => {
                if (result.isConfirmed) {
                    $(this).next().find('.swal_form_submit_btn').trigger('click');
                }
            });
        });

        // toastr warning
        function toastr_warning_js(msg){
            Command: toastr["warning"](msg, "Warning !")
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }
        }
        //toastr success
        function toastr_success_js(msg){
            Command: toastr["success"](msg, "Success !")
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }
        }
    </script>
@endsection
