<!-- Ask Question Popup Starts -->
<div class="popup-overlay"></div>
<div class="popup-fixed question-popup">
    <div class="popup-contents">
        <span class="popup-contents-close popup-close"> <i class="fas fa-times"></i> </span>
        <h2 class="popup-contents-title"> {{ get_static_option('community_question_modal_title') ?? __('Ask a question') }} </h2>
        <form action="{{ route('community.question.tips.post') }}" method="post">
            @csrf
            <div class="popup-contents-form custom-form profile-border-top">
                <div class="single-input">
                    <label class="label-title">{{ __('Choose a type') }}</label>
                    <select class="form-control" name="type" id="type">
                        <option value="">{{ __('Select type') }}</option>
                        <option value="question">{{ __('Question') }}</option>
                        <option value="tips">{{ __('Tips') }}</option>
                    </select>
                </div>
                <div class="single-input">
                    <label class="label-title"> {{ __('Title') }} </label>
                    <input type="text" name="title" id="title" class="w-100 form--control">
                </div>
                <div class="single-input">
                    <label class="label-title"> {{ __('Description') }} </label>
                    <textarea name="description" id="description" cols="40" rows="5" class="w-100 form--control form-message description"></textarea>
                </div>
            </div>
            <div class="popup-contents-btn flex-btn profile-border-top justify-content-end">
                <a href="javascript:void(0)" class="btn-profile btn-outline-gray btn-hover-danger popup-close"> <i
                            class="las la-arrow-left"></i>{{ __('Cancel') }}</a>
                <button type="submit" href="javascript:void(0)" class="btn-profile btn-bg-1" id="submit_question"> {{ __('Submit') }} </button>
            </div>
        </form>
    </div>
</div>
<!-- Ask Question Popup Ends -->