<!-- edit modal -->
<div class="modal fade" id="edit_question_{{  $ques_tip->id }}" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">
                    {{ __('Edit') }} {{ ucfirst($ques_tip->type ?? '') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('community.question.tips.post.edit') }}" method="post">
                    @csrf
                    <input type="hidden" name="question_id" value="{{ $ques_tip->id }}">
                    <div class="popup-contents-form custom-form">
                        <div class="single-input">
                            <label class="label-title">{{ __('Choose a type') }}</label>
                            <select class="form-control" name="type" id="type">
                                <option value="">{{ __('Select type') }}</option>
                                <option value="question" {{ $ques_tip->type == 'question' ? 'selected' : '' }}>{{ __('Question') }}</option>
                                <option value="tips" {{ $ques_tip->type == 'tips' ? 'selected' : '' }}>{{ __('Tips') }}</option>
                            </select>
                        </div>
                        <div class="single-input">
                            <label class="label-title"> {{ __('Title') }} </label>
                            <input type="text" name="title" id="edit_title" value="{{ $ques_tip->title ?? '' }}" class="w-100 form--control">
                        </div>
                        <div class="single-input">
                            <label class="label-title"> {{ __('Description') }} </label>
                            <textarea name="description" id="edit_description" cols="40" rows="5" class="w-100 form--control form-message description">{{ $ques_tip->description ?? '' }}</textarea>
                        </div>
                    </div>
                    <div class="popup-contents-btn flex-btn profile-border-top justify-content-end">
                        <a href="javascript:void(0)" class="btn-profile btn-outline-gray btn-hover-danger popup-close"> <i
                                    class="las la-arrow-left"></i>{{ __('Cancel') }}</a>
                        <button type="submit" href="javascript:void(0)" class="btn-profile btn-bg-1" id="submit_question_edit"> {{ __('Submit') }} </button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>