@extends('frontend.layout.master')
@section('site_title', __('Community'))
@section('meta_title'){{ __('Community') }}@endsection
@section('style')
    <x-summernote.summernote-css/>
@endsection
@section('content')
    <main>
        @if(moduleExists('CoinPaymentGateway'))@else<x-frontend.category.category/>@endif
        <x-breadcrumb.user-profile-breadcrumb :title="__('Community') ?? __('Community')" :innerTitle="__('Community') ?? ''" />
            <div class="profile-settings-area pat-100 pab-100 section-bg-2">
                <div class="container">
                    <div class="row g-4">
                        @if(!empty($question_details_for_notification))
                            @if(Auth::guard('web')->check() && $answer_count >= 1)
                                <div class="col-12">
                                <div class="question-answer mb-5">
                                    <div class="question-answer-flex">
                                        <div class="question-answer-item">
                                            <div class="question-answer-item-icon">
                                                <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M31.6641 14.5833C28.2141 14.5833 25.4141 11.7833 25.4141 8.33325C25.4141 4.88325 28.2141 2.08325 31.6641 2.08325C35.1141 2.08325 37.9141 4.88325 37.9141 8.33325C37.9141 11.7833 35.1141 14.5833 31.6641 14.5833ZM31.6641 4.58325C29.5974 4.58325 27.9141 6.26659 27.9141 8.33325C27.9141 10.3999 29.5974 12.0833 31.6641 12.0833C33.7307 12.0833 35.4141 10.3999 35.4141 8.33325C35.4141 6.26659 33.7307 4.58325 31.6641 4.58325Z" fill="white"/>
                                                    <path d="M19.9974 22.9167H11.6641C10.9807 22.9167 10.4141 22.3501 10.4141 21.6667C10.4141 20.9834 10.9807 20.4167 11.6641 20.4167H19.9974C20.6807 20.4167 21.2474 20.9834 21.2474 21.6667C21.2474 22.3501 20.6807 22.9167 19.9974 22.9167Z" fill="white"/>
                                                    <path d="M26.6641 29.5833H11.6641C10.9807 29.5833 10.4141 29.0166 10.4141 28.3333C10.4141 27.6499 10.9807 27.0833 11.6641 27.0833H26.6641C27.3474 27.0833 27.9141 27.6499 27.9141 28.3333C27.9141 29.0166 27.3474 29.5833 26.6641 29.5833Z" fill="white"/>
                                                    <path d="M25.0026 37.9166H15.0026C5.9526 37.9166 2.08594 34.0499 2.08594 24.9999V14.9999C2.08594 5.94992 5.9526 2.08325 15.0026 2.08325H23.3359C24.0193 2.08325 24.5859 2.64992 24.5859 3.33325C24.5859 4.01659 24.0193 4.58325 23.3359 4.58325H15.0026C7.31927 4.58325 4.58594 7.31659 4.58594 14.9999V24.9999C4.58594 32.6833 7.31927 35.4166 15.0026 35.4166H25.0026C32.6859 35.4166 35.4193 32.6833 35.4193 24.9999V16.6666C35.4193 15.9833 35.9859 15.4166 36.6693 15.4166C37.3526 15.4166 37.9193 15.9833 37.9193 16.6666V24.9999C37.9193 34.0499 34.0526 37.9166 25.0026 37.9166Z" fill="white"/>
                                                </svg>
                                            </div>
                                            <div class="question-answer-item-contents">
                                                <h4 class="question-answer-item-contents-title">{{ get_static_option('community_page_notification_title') ?? __('Your questions has been answered by community members') }}</h4>
                                                <div class="question-answer-item-contents-btn mt-3">
                                                    <a href="{{ route('community.question.details',$question_details_for_notification->slug) }}" class="see-here">{{ __('Click here to see') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="question-answer-close">
                                            <i class="fa-solid fa-xmark"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        @endif
                    </div>

                    <div class="contact-question">
                            <div class="row gy-5 justify-content-between flex-column-reverse flex-lg-row">
                                <div class="col-xxl-6 col-lg-6">
                                    <div class="contact-question-search contact-question-search-padding">
                                        <h2 class="contact-question-search-title">{{ get_static_option('community_page_title') ?? __('Get answers to your questions by our expert community members')}}</h2>
                                        <div class="contact-question-search-form custom-form mt-4">

                                            <form action="#">
                                                <div class="contact-question-search-form-flex">
                                                    <div class="single-input">
                                                        <input type="text" id="question_tips_search_string" class="form--control input-padding-left" placeholder="{{ __('Search question') }}">
                                                        <span class="input-icon"> <i class="fa-solid fa-search"></i> </span>
                                                    </div>
                                                    <div class="question_tips_search_type">
                                                        <select id="question_tips_search_type" class="btn btn-primary">
                                                            <option value="question">{{ __('Question') }}</option>
                                                            <option value="tips">{{ __('Tips') }}</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </form>

                                            <div class="display_question_tip_search_result"></div>

                                            <div class="contact-question-search-or">
                                                <span class="contact-question-search-or-title">{{ __('OR') }}</span>
                                            </div>

                                            <x-validation.error />

                                            <div class="btn-wrapper">
                                                @if(Auth::guard('web')->check())
                                                    <a href="javascript:void(0)" class="cmn-btn btn-outline-1 color-one w-100 question-click">{{ __('Ask a Question') }}</a>
                                                @else
                                                    <a href="{{ route('user.login') }}" class="cmn-btn btn-outline-1 color-one w-100">{{get_static_option('community_question_button_title') ?? __('Login to Ask a Question') }}</a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-5 col-lg-6">
                                    <div class="contact-question-thumb">
                                        @if(!empty(get_static_option('community_page_image')))
                                        {!! render_image_markup_by_attachment_id(get_static_option('community_page_image')) ?? '' !!}
                                        @else
                                          <img src="{{ asset('assets/static/img/contact.png') }}" alt="{{__('No Image')}}">
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                    <div class="row g-4 mt-4">
                        <div class="col-lg-6">
                            <a href="{{ route('community.question.all') }}" tabindex="0">
                                <div class="most-search-single">
                                    <div class="most-search-single-icon">
                                        <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.8048 5.06821L20.1316 0.404388C19.8704 0.143555 19.5228 0 19.1534 0H5.83875C4.1571 0 2.78906 1.36612 2.78906 3.0452V24.9548C2.78906 26.6339 4.1571 28 5.83875 28H22.1613C23.8429 28 25.2109 26.6339 25.2109 24.9548V6.04681C25.2109 5.67703 25.0667 5.32947 24.8048 5.06821ZM20.2075 2.79782L22.4073 4.99323H20.4591C20.3203 4.99323 20.2075 4.8815 20.2075 4.74393V2.79782ZM22.1613 26.3594H5.83875C5.0618 26.3594 4.42969 25.7294 4.42969 24.9548V3.0452C4.42969 2.2706 5.0618 1.64062 5.83875 1.64062H18.5668V4.74393C18.5668 5.78619 19.4156 6.63385 20.4589 6.63385H23.5703V24.9548C23.5703 25.7294 22.9382 26.3594 22.1613 26.3594Z" fill="#FFA500"></path>
                                            <path d="M9.74515 18.3666H18.2614C18.935 18.3666 19.4832 17.8185 19.4832 17.1449V14.9124C19.4832 13.3694 18.3283 12.0908 16.8376 11.8958C17.1284 11.4055 17.2957 10.8336 17.2957 10.2235V8.54553C17.2957 6.73294 15.821 5.2583 14.0084 5.2583H13.9982C12.1856 5.2583 10.7109 6.73294 10.7109 8.54553V10.2235C10.7109 10.8336 10.8782 11.4055 11.1689 11.8958C9.67828 12.0908 8.52344 13.3694 8.52344 14.9124V17.1449C8.52344 17.8185 9.07159 18.3666 9.74515 18.3666ZM12.3516 8.54553C12.3516 7.63763 13.0903 6.89893 13.9982 6.89893H14.0084C14.9163 6.89893 15.655 7.63763 15.655 8.54553V10.2235C15.655 11.1314 14.9163 11.8701 14.0084 11.8701H13.9982C13.0903 11.8701 12.3516 11.1314 12.3516 10.2235V8.54553ZM10.1641 14.9126C10.1641 14.1395 10.793 13.5108 11.5659 13.5108H16.4407C17.2136 13.5108 17.8423 14.1397 17.8423 14.9126V16.726H10.1641V14.9126Z" fill="#FFA500"></path>
                                            <path d="M18.9004 19.9873H9.34375C8.89066 19.9873 8.52344 20.3545 8.52344 20.8076C8.52344 21.2607 8.89066 21.6279 9.34375 21.6279H18.9004C19.3533 21.6279 19.7207 21.2607 19.7207 20.8076C19.7207 20.3545 19.3535 19.9873 18.9004 19.9873Z" fill="#FFA500"></path>
                                            <path d="M16.7129 22.7217H11.5312C11.0782 22.7217 10.7109 23.0889 10.7109 23.542C10.7109 23.9951 11.0782 24.3623 11.5312 24.3623H16.7129C17.1658 24.3623 17.5332 23.9951 17.5332 23.542C17.5332 23.0889 17.166 22.7217 16.7129 22.7217Z" fill="#FFA500"></path>
                                        </svg>
                                    </div>
                                    <div class="most-search-single-contents mt-3">
                                        <h4 class="most-search-single-contents-title">{{ __('Question') }}({{$question_count ?? 0}})</h4>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="col-lg-6">
                            <a href="{{ route('community.tip.all') }}" tabindex="0">
                                <div class="most-search-single">
                                    <div class="most-search-single-icon">
                                        <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.8048 5.06821L20.1316 0.404388C19.8704 0.143555 19.5228 0 19.1534 0H5.83875C4.1571 0 2.78906 1.36612 2.78906 3.0452V24.9548C2.78906 26.6339 4.1571 28 5.83875 28H22.1613C23.8429 28 25.2109 26.6339 25.2109 24.9548V6.04681C25.2109 5.67703 25.0667 5.32947 24.8048 5.06821ZM20.2075 2.79782L22.4073 4.99323H20.4591C20.3203 4.99323 20.2075 4.8815 20.2075 4.74393V2.79782ZM22.1613 26.3594H5.83875C5.0618 26.3594 4.42969 25.7294 4.42969 24.9548V3.0452C4.42969 2.2706 5.0618 1.64062 5.83875 1.64062H18.5668V4.74393C18.5668 5.78619 19.4156 6.63385 20.4589 6.63385H23.5703V24.9548C23.5703 25.7294 22.9382 26.3594 22.1613 26.3594Z" fill="#FFA500"></path>
                                            <path d="M9.74515 18.3666H18.2614C18.935 18.3666 19.4832 17.8185 19.4832 17.1449V14.9124C19.4832 13.3694 18.3283 12.0908 16.8376 11.8958C17.1284 11.4055 17.2957 10.8336 17.2957 10.2235V8.54553C17.2957 6.73294 15.821 5.2583 14.0084 5.2583H13.9982C12.1856 5.2583 10.7109 6.73294 10.7109 8.54553V10.2235C10.7109 10.8336 10.8782 11.4055 11.1689 11.8958C9.67828 12.0908 8.52344 13.3694 8.52344 14.9124V17.1449C8.52344 17.8185 9.07159 18.3666 9.74515 18.3666ZM12.3516 8.54553C12.3516 7.63763 13.0903 6.89893 13.9982 6.89893H14.0084C14.9163 6.89893 15.655 7.63763 15.655 8.54553V10.2235C15.655 11.1314 14.9163 11.8701 14.0084 11.8701H13.9982C13.0903 11.8701 12.3516 11.1314 12.3516 10.2235V8.54553ZM10.1641 14.9126C10.1641 14.1395 10.793 13.5108 11.5659 13.5108H16.4407C17.2136 13.5108 17.8423 14.1397 17.8423 14.9126V16.726H10.1641V14.9126Z" fill="#FFA500"></path>
                                            <path d="M18.9004 19.9873H9.34375C8.89066 19.9873 8.52344 20.3545 8.52344 20.8076C8.52344 21.2607 8.89066 21.6279 9.34375 21.6279H18.9004C19.3533 21.6279 19.7207 21.2607 19.7207 20.8076C19.7207 20.3545 19.3535 19.9873 18.9004 19.9873Z" fill="#FFA500"></path>
                                            <path d="M16.7129 22.7217H11.5312C11.0782 22.7217 10.7109 23.0889 10.7109 23.542C10.7109 23.9951 11.0782 24.3623 11.5312 24.3623H16.7129C17.1658 24.3623 17.5332 23.9951 17.5332 23.542C17.5332 23.0889 17.166 22.7217 16.7129 22.7217Z" fill="#FFA500"></path>
                                        </svg>
                                    </div>
                                    <div class="most-search-single-contents mt-3">
                                        <h4 class="most-search-single-contents-title">
                                           {{ __('Tips') }}({{ $tips_count ?? 0 }})</h4>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>

                    {{--question tips--}}
                    <div class="row g-4 mt-4 question-tips-wrapper">
                        @if(!empty($user_question_tips))
                            @if(Auth::guard('web')->check())
                                <div class="col-12">
                                    <div class="single-profile-settings">
                                        <div class="single-profile-settings-header">
                                            <div class="single-profile-settings-header-flex">
                                                <a href="#/" class="btn-profile btn-bg-1"> {{ __('Your Question/Tips') }} </a>
                                            </div>
                                        </div>
                                        <div class="single-profile-settings-inner profile-border-top">
                                            <div class="custom_table style-04">
                                                <table>
                                                    <thead>
                                                    <tr>
                                                        <th>{{ __('Title') }}</th>
                                                        <th>{{ __('Type') }}</th>
                                                        <th>{{ __('Reactions') }}</th>
                                                        <th>{{ __('Status') }}</th>
                                                        <th>{{ __('Create Date') }}</th>
                                                        <th>{{ __('Action') }}</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach($user_question_tips as $ques_tip)
                                                        <tr>
                                                            <td>{{ Str::limit($ques_tip->title,50) }}</td>
                                                            <td>{{ ucfirst($ques_tip->type) }}</td>
                                                            <td>
                                                                <i class="fa-solid fa-heart text-danger fs-6"></i> <span>{{ $ques_tip->question_like_reaction_count }}</span> &nbsp;
                                                                <i class="fa-solid fa-face-sad-tear text-warning fs-6"></i> <span>{{ $ques_tip->question_sad_reaction_count }}</span> &nbsp;
                                                                <i class="fa-regular fa-circle-up text-primary fs-6"></i> <span>{{ $ques_tip->question_up_reaction_count }}</span> &nbsp;
                                                                <i class="fas fa-life-ring text-info fs-6"></i> <span>{{ $ques_tip->question_support_reaction_count }}</span> &nbsp;
                                                                <i class="fa-solid fa-sun text-success fs-6"></i> <span>{{ $ques_tip->question_congrats_reaction_count }}</span> &nbsp;
                                                            </td>
                                                            <td>{{ $ques_tip->status === 1 ? 'Active' : 'Inactive' }}</td>
                                                            <td>{{ $ques_tip->created_at->toFormattedDateString() }}</td>
                                                            <td>
                                                                <a tabindex="0" class="btn btn-sm btn-danger delete_question"><i class="fa-solid fa-square-xmark"></i></a>
                                                                <form method='post' action='{{ route('community.question.delete',$ques_tip->id) }}' class="d-none">
                                                                    <input type='hidden' name='_token' value='{{csrf_token()}}'>
                                                                    <br>
                                                                    <button type="submit" class="swal_form_submit_btn d-none"></button>
                                                                </form>
                                                                <a href="{{ route('freelancer.order.details',$ques_tip->id) }}"
                                                                   class="btn btn-sm btn-primary"
                                                                   data-bs-target="#edit_question_{{$ques_tip->id}}"
                                                                   data-bs-toggle="modal"
                                                                >
                                                                    <i class="fa-solid fa-square-pen"></i>
                                                                </a>
                                                                @include('community::frontend.edit-modal')
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                                <div class="deposit-history-pagination mt-4">
                                                    <x-pagination.laravel-paginate :allData="$user_question_tips"/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endif
                    </div>

                </div>
                </div>
            </div>

            @include('community::frontend.question-modal')
    </main>
@endsection

@section('script')
    <script src="{{asset('assets/backend/js/summernote/summernote-lite.min.js')}}"></script>
    <x-sweet-alert.sweet-alert2-js/>

    <script>
        function initializeSummernote(element, options) {
            element.summernote($.extend({
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link']],
                ],
                callbacks: {
                    onPaste: function(e) {
                        var bufferText = ((e.originalEvent || e).clipboardData || window
                            .clipboardData).getData('Text');
                        e.preventDefault();
                        document.execCommand('insertText', false, bufferText);
                    }
                },
                height: 100
            }, options));
        }
        //use
        initializeSummernote($('.description'), {
            height: 100
        });

        // Function to sanitize HTML content
        function sanitizeHTML(content) {
            // Use jQuery to create a temporary element and set its HTML
            let tempElement = $('<div>').html(content);

            // Remove any script tags
            tempElement.find('script').remove();

            // Return the sanitized HTML
            return tempElement.html();
        }

        $(document).on('click','#submit_question',function (){
            let title_min_length = 10;
            let description_min_length = 50;
            let type = $('#type').val();
            let title_length = $('#title').val().length;
            let description_length = $('#description').val().length;

            if(type == '' || title_length == '' || description_length == ''){
                toastr_warning_js("{{'All fields are required'}}");
                return false;
            }else{
                if(title_length < title_min_length || title_length > 100){
                    toastr_warning_js("{{'Title must be between 10 to 100 character.'}}");
                    return false;
                }
                if(description_length < description_min_length){
                    toastr_warning_js("{{'Description must be greater than or equal to 50.'}}");
                    return false;
                }
            }
        })

        $(document).on('click','#submit_question_edit',function (){
            let title_min_length = 10;
            let description_min_length = 50;
            let type = $('#edit_type').val();
            let title_length = $('#edit_title').val().length;
            let description_length = $('#edit_description').val().length;

            if(type == '' || title_length == '' || description_length == ''){
                toastr_warning_js("{{'All fields are required'}}");
                return false;
            }else{
                if(title_length < title_min_length || title_length > 100){
                    toastr_warning_js("{{'Title must be between 10 to 100 character.'}}");
                    return false;
                }
                if(description_length < description_min_length){
                    toastr_warning_js("{{'Description must be greater than or equal to 50.'}}");
                    return false;
                }
            }
        })

        //delete question
        $(document).on('click','.delete_question',function(e){
            e.preventDefault();
            Swal.fire({
                title: '{{__("Are you sure to delete?")}}',
                text: '{{__("You would not be able to revert this item!")}}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{__('Yes, Delete it!')}}"
            }).then((result) => {
                if (result.isConfirmed) {
                    $(this).next().find('.swal_form_submit_btn').trigger('click');
                }
            });
        });

        //question tip search from community page
        $(document).on('keyup', '#question_tips_search_string',function(){
            let search_string = $('#question_tips_search_string').val();
            let search_type = $('#question_tips_search_type').val();
            $('.display_question_tip_search_result').hide()

            if(search_string.length >= 1){
                $('.display_question_tip_search_result').show()
                $.ajax({
                    url:"{{route('community.search')}}",
                    method:"GET",
                    data:{search_string:search_string, search_type:search_type},
                    success:function(res){
                        $('.display_question_tip_search_result').html(res);
                    }
                })
            }else{
                $('.display_question_tip_search_result').html('');
            }

        })

        // toastr warning
        function toastr_warning_js(msg){
            Command: toastr["warning"](msg, "Warning !")
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }
        }
        //toastr success
        function toastr_success_js(msg){
            Command: toastr["success"](msg, "Success !")
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "newestOnTop": false,
                "progressBar": true,
                "positionClass": "toast-top-right",
                "preventDuplicates": false,
                "onclick": null,
                "showDuration": "300",
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }
        }
    </script>
@endsection
