<x-validation.error />
<table class="DataTable_activation">
    <thead>
    <tr>
        <th>{{__('ID')}}</th>
        <th>{{__('Title')}}</th>
        <th>{{__('Type')}}</th>
        <th>{{__('Status (change by admin)')}}</th>
        <th>{{__('Action')}}</th>
    </tr>
    </thead>
    <tbody>
    @foreach($question_tips as $q_t)
        <tr>
            <td>000{{ $q_t->id }}</td>
            <td>
                {{ $q_t->title }} <br>
            </td>
            <td>
                {{ $q_t->type == 'question' ? 'Question' : 'Tips' }} <br>
            </td>
            <td>
                <x-status.table.active-inactive :status="$q_t->status"/>
            </td>
            <td>
                <x-status.table.select-action :title="__('Select Action')"/>
                <ul class="dropdown-menu status_dropdown__list">
                    <li class="status_dropdown__item">
                        <a target="_blank" href="{{ route('community.question.details',$q_t->slug) }}" class="btn dropdown-item status_dropdown__list__link">{{ __('Details') }}</a>
                    </li>
                    @can('job-delete')
                    <li class="status_dropdown__item">
                        <x-popup.delete-popup :title="__('Delete')" :url="route('admin.community.question.tip.delete',$q_t->id)"/>
                    </li>
                    @endcan
                    @can('job-status-change')
                    <li class="status_dropdown__item">
                        @if($q_t->status === 0)
                            <x-status.table.status-change :title="__('Active')" :url="route('admin.community.question.status.change',$q_t->id)"/>
                        @else
                            <x-status.table.status-change :title="__('Inactivate')" :url="route('admin.community.question.status.change',$q_t->id)"/>
                        @endif
                    </li>
                    @endcan
                </ul>
            </td>
        </tr>
    @endforeach
    </tbody>
</table>
<x-pagination.laravel-paginate :allData="$question_tips"/>
