@extends('backend.layout.master')
@section('title', __('Community Page Settings'))
@section('style')
    <x-media.css/>
@endsection
@section('content')
    <div class="dashboard__body">
        <div class="row">
            <div class="col-lg-6">
                <div class="customMarkup__single">
                    <div class="customMarkup__single__item">
                        <div class="customMarkup__single__item__flex">
                            <h4 class="customMarkup__single__title">{{ __('Community Page Settings') }}</h4>
                        </div>
                        <x-validation.error />
                        <div class="customMarkup__single__inner mt-4">
                            <form action="{{route('admin.community.page.settings')}}" method="post">
                                @csrf
                                <x-form.text :title="__('Community Page Title')" :type="__('text')" :name="'community_page_title'" :value="get_static_option('community_page_title') ?? '' " :placeholder="__('Enter title')"/>
                                <br>
                                <x-form.text :title="__('Community Question Button Title')" :type="__('text')" :name="'community_question_button_title'" :value="get_static_option('community_question_button_title') ?? '' " :placeholder="__('Enter title')"/>
                                <br>
                                <x-form.text :title="__('Community Question Modal Title')" :type="__('text')" :name="'community_question_modal_title'" :value="get_static_option('community_question_modal_title') ?? '' " :placeholder="__('Enter modal title')"/>
                                <br>
                                <x-form.text :title="__('Community Notification Box Title')" :type="__('text')" :name="'community_page_notification_title'" :value="get_static_option('community_page_notification_title') ?? '' " :placeholder="__('Enter title')"/>
                                <br>
                                <x-form.text :title="__('Question Page Subtitle')" :type="__('text')" :name="'community_question_page_subtitle'" :value="get_static_option('community_question_page_subtitle') ?? '' " :placeholder="__('Enter title')"/>
                                <br>
                                <x-form.text :title="__('Tips Page Subtitle')" :type="__('text')" :name="'community_tips_page_subtitle'" :value="get_static_option('community_tips_page_subtitle') ?? '' " :placeholder="__('Enter title')"/>
                                <br>
                                <x-backend.image :title="__('Community Page Image')" :name="'community_page_image'" :dimentions="'550x370'"/>
                                <x-btn.submit :title="__('Update')" :class="'btn btn-primary mt-4 pr-4 pl-4'" />
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-media.markup/>
@endsection

@section('script')
    <x-media.js/>
@endsection
