<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_tip_answer_reactions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('question_tip_id');
            $table->bigInteger('answer_id');
            $table->bigInteger('user_id');
            $table->integer('status')->nullable()->comment('0 for inactive, 1 for active');
            $table->string('like')->nullable();
            $table->string('haha')->nullable();
            $table->string('up')->nullable();
            $table->string('sad')->nullable();
            $table->string('support')->nullable();
            $table->string('congrats')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_tip_answer_reactions');
    }
};
