<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_tip_answers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('question_tip_id');
            $table->bigInteger('user_id');
            $table->text('answer');
            $table->foreignId('parent_answer_id')->nullable();
            $table->integer('is_author_reply')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_tip_answers');
    }
};
