<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('question_tips', function (Blueprint $table) {
            $table->id();
            $table->string('type');
            $table->string('title');
            $table->string('slug');
            $table->longText('description');
            $table->bigInteger('vote')->default(0);
            $table->bigInteger('question_user_id');
            $table->integer('status')->default(0)->comment('0 for inactive, 1 for active');
            $table->bigInteger('like')->default(0);
            $table->bigInteger('haha')->default(0);
            $table->bigInteger('up')->default(0);
            $table->bigInteger('sad')->default(0);
            $table->bigInteger('support')->default(0);
            $table->bigInteger('congrats')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('question_tips');
    }
};
