<?php

namespace Modules\Community\App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Community\Database\factories\QuestionTipAnswerReplyFactory;

class QuestionTipAnswerReply extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['question_tip_id','user_id','answer_id','reply'];
    
    protected static function newFactory(): QuestionTipAnswerReplyFactory
    {
        //return QuestionTipAnswerReplyFactory::new();
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }
}
