<?php

namespace Modules\Community\App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Community\Database\factories\QuestionTipAnswerFactory;

class QuestionTipAnswer extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['question_tip_id', 'user_id', 'answer', 'parent_answer_id', 'is_author_reply'];
    protected $casts = [
        'is_author_reply' => 'boolean',
    ];
    
    protected static function newFactory(): QuestionTipAnswerFactory
    {
        //return QuestionTipAnswerFactory::new();
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function question()
    {
        return $this->belongsTo(QuestionTip::class,'question_tip_id','id');
    }

    public function answer_like_reaction(){
        return $this->hasMany(QuestionTipAnswerReaction::class,'answer_id','id')->where('like','like');
    }

    public function answer_sad_reaction(){
        return $this->hasMany(QuestionTipAnswerReaction::class,'answer_id','id')->where('sad','sad');
    }

    public function answer_up_reaction(){
        return $this->hasMany(QuestionTipAnswerReaction::class,'answer_id','id')->where('up','up');
    }

    public function answer_support_reaction(){
        return $this->hasMany(QuestionTipAnswerReaction::class,'answer_id','id')->where('support','support');
    }

    public function answer_congrats_reaction(){
        return $this->hasMany(QuestionTipAnswerReaction::class,'answer_id','id')->where('congrats','congrats');
    }

    public function answer_reply()
    {
        return $this->hasMany(QuestionTipAnswerReply::class, 'answer_id','id');
    }
}
