<?php

namespace Modules\Community\App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\Community\Database\factories\QuestionTipFactory;

class QuestionTip extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = ['type','title','slug','description','vote','question_user_id','status','like','haha','up','sad','support','congrats'];
    
    protected static function newFactory(): QuestionTipFactory
    {
        //return QuestionTipFactory::new();
    }

    public function user()
    {
        return $this->belongsTo(User::class,'question_user_id','id');
    }

    public function questions(){
        return $this->hasMany(QuestionTipAnswer::class,'question_tip_id','id');
    }

    public function answer(){
        return $this->hasMany(QuestionTipAnswer::class,'question_tip_id','id');
    }

    public function question_like_reaction(){
        return $this->hasMany(QuestionTipReaction::class,'question_tip_id','id')->where('like','like');
    }

    public function question_sad_reaction(){
        return $this->hasMany(QuestionTipReaction::class,'question_tip_id','id')->where('sad','sad');
    }

    public function question_up_reaction(){
        return $this->hasMany(QuestionTipReaction::class,'question_tip_id','id')->where('up','up');
    }
    public function question_support_reaction(){
        return $this->hasMany(QuestionTipReaction::class,'question_tip_id','id')->where('support','support');
    }
    public function question_congrats_reaction(){
        return $this->hasMany(QuestionTipReaction::class,'question_tip_id','id')->where('congrats','congrats');
    }
}
