<?php

namespace Modules\Community\App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Modules\Blog\Entities\BlogPost;
use Modules\Community\App\Models\QuestionTip;
use Modules\Community\App\Models\QuestionTipAnswer;
use Modules\Faq\Entities\QuestionAnswer;

class FrontendCommunityController extends Controller
{
    public function community(Request $request)
    {
        $question_count = QuestionTip::where('type','question')->count();
        $tips_count = QuestionTip::where('type','tips')->count();
        $blog_count = BlogPost::where('status',1)->count();
        $answer_count = 0;
        $user_question_tips = '';
        $question_details_for_notification = '';
        if(Auth::guard('web')->check()){
            $answer_count = QuestionTipAnswer::whereHas('question',function($query){
                $query->where('question_user_id',Auth::guard('web')->user()->id);
            })
                ->where('is_author_reply',0)->count();
            $question_details_for_notification = QuestionTip::where('question_user_id', Auth::guard('web')->user()->id)->where('type','question')
                ->whereHas('answer', function ($query) {
                    $query->where('is_author_reply', 0);
                })
                ->first();
            $user_question_tips = QuestionTip::where('status',1)
                ->withCount(['question_like_reaction','question_sad_reaction','question_up_reaction','question_support_reaction','question_congrats_reaction'])
                ->where('question_user_id',Auth::guard('web')->user()->id)
                ->latest()
                ->paginate(10);
        }

        return view('community::frontend.community',compact(['question_count','tips_count','blog_count','user_question_tips','answer_count','question_details_for_notification']));
    }

    public function question_all()
    {
        $user_questions = QuestionTip::with(['user'])
            ->where('status',1)
            ->where('type','question')
            ->withCount(['answer','question_up_reaction'])
            ->latest()
            ->paginate(10);
        return view('community::frontend.question.all-question',compact(['user_questions']));
    }

    public function tips_all()
    {
        $user_tips = QuestionTip::with(['user'])
            ->where('status',1)
            ->where('type','tips')
            ->withCount(['answer','question_up_reaction'])
            ->latest()
            ->paginate(10);
        return view('community::frontend.tips.all-tips',compact(['user_tips']));
    }

    public function question_details($slug)
    {
        $question_details = QuestionTip::with(['user:id,first_name,last_name,image,username'])
            ->withCount(['question_like_reaction','question_sad_reaction','question_up_reaction','question_support_reaction','question_congrats_reaction'])
            ->where('slug',$slug)->firstOrFail();

        $question_answers = QuestionTipAnswer::with('user:id,first_name,last_name,image,username')
            ->withCount(['answer_like_reaction','answer_sad_reaction','answer_up_reaction','answer_support_reaction','answer_congrats_reaction','answer_reply'])
            ->where('question_tip_id',$question_details->id)
            ->latest()
            ->paginate(10);


        if(Auth::guard('web')->check() && $question_details->question_user_id == Auth::guard('web')->user()->id){
            QuestionTipAnswer::where('question_tip_id',$question_details->id)->update(['is_author_reply'=>1]);
        }
        $latest_questions = QuestionTip::with(['user','questions'])->where('status',1)->where('type','question')->latest()->take(10)->get();
        $latest_tips = QuestionTip::with(['user','questions'])->where('status',1)->latest()->take(10)->where('type','tips')->get();
        return view('community::frontend.question.details',compact(['slug','question_details','question_answers','latest_questions','latest_tips']));
    }

    public function question_answer(Request $request)
    {
        if($request->ajax()){
            $request->validate([
                'answer' => 'required',
            ]);

            $answer = QuestionTipAnswer::create([
                'question_tip_id' => $request->question_id,
                'answer' => $request->answer,
                'is_author_reply' => 0,
                'user_id' => Auth::guard('web')->user()->id,
            ]);
            if(!empty($answer)){
                $question_details = QuestionTip::with(['user:id,first_name,last_name,image,username'])
                    ->withCount(['question_like_reaction','question_sad_reaction','question_up_reaction','question_support_reaction','question_congrats_reaction'])
                    ->where('id',$request->question_id)->firstOrFail();

                $question_answers = QuestionTipAnswer::with('user:id,first_name,last_name,image,username')
                    ->withCount(['answer_like_reaction','answer_sad_reaction','answer_up_reaction','answer_support_reaction','answer_congrats_reaction','answer_reply'])
                    ->where('question_tip_id',$request->question_id)
                    ->latest()
                    ->paginate(10);

                return view('community::frontend.question.search-answers',compact(['answer','question_answers','question_details']))->render();
            }
        }else{
            abort(404);
        }

    }

    //edit answer
    public function question_answer_edit(Request $request)
    {
        if($request->ajax()){
            $request->validate([
                'answer' => 'required',
            ]);
            $answer = QuestionTipAnswer::where('id',$request->answer_id)->first();

            if(!empty($answer)){
                QuestionTipAnswer::where('id',$request->answer_id)->update(['answer' => $request->answer]);
                $question_details = QuestionTip::with(['user:id,first_name,last_name,image,username'])
                    ->withCount(['question_like_reaction','question_sad_reaction','question_up_reaction','question_support_reaction','question_congrats_reaction'])
                    ->where('id',$answer->question_tip_id)->firstOrFail();

                $question_answers = QuestionTipAnswer::with('user:id,first_name,last_name,image,username')
                    ->withCount(['answer_like_reaction','answer_sad_reaction','answer_up_reaction','answer_support_reaction','answer_congrats_reaction','answer_reply'])
                    ->where('question_tip_id',$answer->question_tip_id)
                    ->latest()
                    ->paginate(10);
                return view('community::frontend.question.search-answers',compact(['answer','question_answers','question_details']))->render();
            }
        }else{
            abort(404);
        }

    }

    public function paginate(Request $request)
    {
        if($request->ajax()){
            $question_answers = QuestionTipAnswer::with('user')->where('question_tip_id',$request->question_id)->latest()->paginate(10);
            $question_details = QuestionTip::with(['user'])->where('id',$request->question_id)->firstOrFail();

            return view('community::frontend.question.search-answers', compact(['question_answers','question_details']))->render();
        }
    }

    //search community question tip
    public function search(Request $request)
    {
        $search_type = $request->search_type ?? '';
        if($search_type == 'question')
        {
            $question_tips = QuestionTip::select(['id','title','slug'])
                ->where('type','question')
                ->where('status','1')
                ->where('title','LIKE','%'.strip_tags($request->search_string).'%')
                ->latest()
                ->get();
        }else if($search_type == 'tips'){
            $question_tips = QuestionTip::select('id','title','slug')
                ->where('status','1')
                ->where('type','tips')
                ->where('title','LIKE','%'.strip_tags($request->job_search_string).'%')
                ->latest()
                ->get();
        }
        return view('community::frontend.search-result',compact(['question_tips','search_type']))->render();
    }
}
