<?php

namespace Modules\Community\App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Modules\Community\App\Models\QuestionTip;
use Modules\Community\App\Models\QuestionTipAnswerReaction;
use Modules\Community\App\Models\QuestionTipReaction;

class ReactionController extends Controller
{

    public function reaction_for_question(Request $request)
    {
        if($request->ajax()){
            if($request->reaction == 'like'){
                QuestionTipReaction::where('question_tip_id',$request->question_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipReaction::create([
                    'question_tip_id' => $request->question_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'like' => $request->reaction
                ]);
            }
            if($request->reaction == 'sad'){
                QuestionTipReaction::where('question_tip_id',$request->question_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipReaction::create([
                    'question_tip_id' => $request->question_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'sad' => $request->reaction
                ]);
            }
            if($request->reaction == 'up'){
                QuestionTipReaction::where('question_tip_id',$request->question_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipReaction::create([
                    'question_tip_id' => $request->question_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'up' => $request->reaction
                ]);
            }
            if($request->reaction == 'support'){
                QuestionTipReaction::where('question_tip_id',$request->question_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipReaction::create([
                    'question_tip_id' => $request->question_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'support' => $request->reaction
                ]);
            }
            if($request->reaction == 'congrats'){
                QuestionTipReaction::where('question_tip_id',$request->question_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipReaction::create([
                    'question_tip_id' => $request->question_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'congrats' => $request->reaction
                ]);
            }
            return response()->json(['status' => 'success']);
        }
        abort(404);
    }

    public function reaction_for_question_answer(Request $request)
    {
        if($request->ajax()){
            if($request->reaction == 'like'){
                QuestionTipAnswerReaction::where('question_tip_id',$request->question_id)->where('answer_id',$request->answer_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipAnswerReaction::create([
                    'question_tip_id' => $request->question_id,
                    'answer_id' => $request->answer_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'like' => $request->reaction
                ]);
            }
            if($request->reaction == 'sad'){
                QuestionTipAnswerReaction::where('question_tip_id',$request->question_id)->where('answer_id',$request->answer_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipAnswerReaction::create([
                    'question_tip_id' => $request->question_id,
                    'answer_id' => $request->answer_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'sad' => $request->reaction
                ]);
            }
            if($request->reaction == 'up'){
                QuestionTipAnswerReaction::where('question_tip_id',$request->question_id)->where('answer_id',$request->answer_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipAnswerReaction::create([
                    'question_tip_id' => $request->question_id,
                    'answer_id' => $request->answer_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'up' => $request->reaction
                ]);
            }
            if($request->reaction == 'support'){
                QuestionTipAnswerReaction::where('question_tip_id',$request->question_id)->where('answer_id',$request->answer_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipAnswerReaction::create([
                    'question_tip_id' => $request->question_id,
                    'answer_id' => $request->answer_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'support' => $request->reaction
                ]);
            }
            if($request->reaction == 'congrats'){
                QuestionTipAnswerReaction::where('question_tip_id',$request->question_id)->where('answer_id',$request->answer_id)->where('user_id',Auth::guard('web')->user()->id)->delete();
                QuestionTipAnswerReaction::create([
                    'question_tip_id' => $request->question_id,
                    'answer_id' => $request->answer_id,
                    'user_id' => Auth::guard('web')->user()->id,
                    'congrats' => $request->reaction
                ]);
            }
            return response()->json(['status' => 'success','answer_id' => $request->answer_id]);
        }
        abort(404);
    }
}
