<?php

namespace Modules\Community\App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Modules\Community\App\Models\QuestionTip;
use Modules\Community\App\Models\QuestionTipAnswer;
use Modules\Community\App\Models\QuestionTipAnswerReaction;
use Modules\Community\App\Models\QuestionTipAnswerReply;
use Modules\Community\App\Models\QuestionTipReaction;

class QuestionTipController extends Controller
{
    public function question_post(Request $request)
    {
        if($request->isMethod('POST')) {
            if(Auth::guard('web')->check()) {
                $request->validate([
                    'title' => 'required|unique:question_tips,title|max:255',
                    'type' => 'required',
                    'description' => 'required|max:50000',
                ]);
                QuestionTip::create([
                    'title' => $request->title,
                    'slug' => Str::slug($request->title, '-'),
                    'type' => $request->type,
                    'status' => 1,
                    'description' => $request->description,
                    'question_user_id' => Auth::guard('web')->user()->id,
                ]);
                $msg = ucfirst(__($request->type) . __(' created successfully!'));
                return back()->with(toastr_success($msg));
            }
        }
    }

    public function question_post_edit(Request $request)
    {
        if($request->isMethod('POST')) {
            if(Auth::guard('web')->check()) {
                $request->validate([
                    'title' => 'required|max:255',
                    'type' => 'required',
                    'description' => 'required',
                ]);
                $question = QuestionTip::where('id', $request->question_id)->first();
                QuestionTip::where('id',$request->question_id)->update([
                    'title' => $request->title,
                    'slug' => $question->slug,
                    'type' => $request->type,
                    'description' => $request->description,
                    'question_user_id' => Auth::guard('web')->user()->id,
                ]);
                $msg = ucfirst(__($request->type) . __(' updated successfully!'));
                return back()->with(toastr_success($msg));
            }
        }
        return view('community::create');
    }

    public function delete_question($id)
    {
        QuestionTipReaction::where('question_tip_id',$id)->delete();
        QuestionTipAnswer::where('question_tip_id',$id)->delete();
        QuestionTipAnswerReaction::where('question_tip_id',$id)->delete();
        QuestionTipAnswerReply::where('question_tip_id',$id)->delete();
        QuestionTip::find($id)->delete();
        return back()->with(toastr_success(__("Question deleted successfully!")));
    }
}
