<?php

namespace Modules\Community\App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Modules\Community\App\Models\QuestionTip;
use Modules\Community\App\Models\QuestionTipAnswer;
use Modules\Community\App\Models\QuestionTipAnswerReply;

class AnsweReplyController extends Controller
{
    public function answer_reply(Request $request)
    {
        $request->validate([
            'answer_reply' => 'required|max:50000',
        ]);

        $answer = QuestionTipAnswer::find($request->answer_id);
        $question_details = QuestionTip::with(['user'])->where('id',$request->question_id)->firstOrFail();

        QuestionTipAnswerReply::create([
            'question_tip_id' => $request->question_id,
            'answer_id' => $request->answer_id,
            'user_id' => Auth::guard('web')->user()->id ?? 0,
            'reply' => $request->answer_reply,
        ]);
        return view('community::frontend.question.author-reply-for-answer', compact(['answer','question_details']))->render();
    }

    public function answer_reply_edit(Request $request)
    {
        if($request->ajax()){
            $request->validate([
                'answer_reply' => 'required|max:50000',
            ]);

            $reply = QuestionTipAnswerReply::find($request->reply_id);
            $answer = QuestionTipAnswer::find($request->answer_id);
            $question_details = QuestionTip::with(['user'])->where('id',$answer->question_tip_id)->firstOrFail();

            QuestionTipAnswerReply::where('id',$reply->id)->update([
                'reply' => $request->answer_reply,
            ]);
            return view('community::frontend.question.author-reply-for-answer', compact(['reply','answer','question_details']))->render();
        }
        abort(404);
    }
}
