<?php

namespace Modules\Community\App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Mail\BasicMail;
use App\Models\AdminNotification;
use App\Models\Bookmark;
use App\Models\JobHistory;
use App\Models\JobPost;
use App\Models\Order;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Mail;
use Modules\Community\App\Models\QuestionTip;
use Modules\Community\App\Models\QuestionTipAnswer;
use Modules\Community\App\Models\QuestionTipAnswerReaction;
use Modules\Community\App\Models\QuestionTipAnswerReply;
use Modules\Community\App\Models\QuestionTipReaction;

class CommunityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function question_tips()
    {
        $question_tips = QuestionTip::latest()->paginate(10);
        return view('community::backend.question-tip.question-tip',compact('question_tips'));
    }


    // search job
    public function search_question_tip(Request $request)
    {
        $question_tips = QuestionTip::where('title', 'LIKE', "%". strip_tags($request->string_search) ."%")
            ->orWhere('type', 'LIKE', "%". strip_tags($request->string_search) ."%")
            ->latest()->paginate(10);
        return $question_tips->total() >= 1 ? view('community::backend.question-tip.search-result', compact('question_tips'))->render() : response()->json(['status'=>__('nothing')]);
    }

    // pagination
    function pagination(Request $request)
    {
        if($request->ajax()){
            if(!empty($request->string_search)){
                $question_tips= JobPost::where('title', 'LIKE', "%". strip_tags($request->string_search) ."%")
                    ->orWhere('type','LIKE', "%". strip_tags($request->string_search) ."%")
                    ->latest()->paginate(10);
            }else{
                $question_tips = QuestionTip::latest()->paginate(10);
            }
            return view('community::backend.question-tip.search-result', compact('question_tips'))->render();
        }
    }

    //  job status change active-to-inactive-to-active
    public function change_status($id=null)
    {
        $question_tip = QuestionTip::where('id',$id)->first();

        $status = $question_tip->status == 1 ? 0 : 1;
        QuestionTip::where('id',$id)->update(['status'=>$status]);
            return back()->with(toastr_success(__('Status Successfully Updated')));
    }

    // delete single job
    public function delete_question_tip($id)
    {
        QuestionTipReaction::where('question_tip_id',$id)->delete();
        QuestionTipAnswer::where('question_tip_id',$id)->delete();
        QuestionTipAnswerReaction::where('question_tip_id',$id)->delete();
        QuestionTipAnswerReply::where('question_tip_id',$id)->delete();
        QuestionTip::find($id)->delete();
        return redirect()->back()->with(toastr_error(__('Successfully Deleted.')));
    }

    //hour settings
    public function page_settings(Request $request)
    {
        if($request->isMethod('post')){
            $request->validate([
                'community_page_title' => 'nullable|max:255',
                'community_question_button_title' => 'nullable|max:255',
                'community_question_modal_title' => 'nullable|max:255',
                'community_page_notification_title' => 'nullable|max:255',
                'community_question_page_subtitle' => 'nullable|max:255',
                'community_tips_page_subtitle' => 'nullable|max:255',
                'community_page_image' => 'nullable',
            ]);
            $all_fields = [
                'community_page_title',
                'community_question_button_title',
                'community_question_modal_title',
                'community_page_notification_title',
                'community_question_page_subtitle',
                'community_tips_page_subtitle',
                'community_page_image',
            ];

            foreach ($all_fields as $field) {
                update_static_option($field, $request->$field);
            }
            toastr_success(__('Settings Updated Successfully.'));
            return back();
        }
        return view('community::backend.page-settings.page-settings');
    }

}
